/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.indesign;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.indesign.ContentAndMetadataExtractor;
import org.apache.tika.parser.xmp.XMPMetadataExtractor;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IDMLParser
extends AbstractParser {
    private static final MediaType IDML_CONTENT_TYPE = MediaType.application("vnd.adobe.indesign-idml-package");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(IDML_CONTENT_TYPE);
    private static final String META_NAME = "META-INF/metadata.xml";
    private int pageCount = 0;
    private int masterSpreadCount = 0;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipFile zipFile = null;
        ZipInputStream zipStream = null;
        if (stream instanceof TikaInputStream) {
            TikaInputStream tis = (TikaInputStream)stream;
            Object container = ((TikaInputStream)stream).getOpenContainer();
            if (container instanceof ZipFile) {
                zipFile = (ZipFile)container;
            } else if (tis.hasFile()) {
                zipFile = new ZipFile(tis.getFile());
            } else {
                zipStream = new ZipInputStream(stream);
            }
        } else {
            zipStream = new ZipInputStream(stream);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(baseHandler, metadata);
        xhtml.startDocument();
        EndDocumentShieldingContentHandler handler = new EndDocumentShieldingContentHandler(xhtml);
        if (zipFile != null) {
            try {
                this.handleZipFile(zipFile, metadata, context, handler);
            }
            finally {
                zipFile.close();
            }
        }
        try {
            this.handleZipStream(zipStream, metadata, context, handler);
        }
        finally {
            zipStream.close();
        }
        metadata.set("SpreadPageCount", Integer.toString(this.pageCount));
        metadata.set("MasterSpreadPageCount", Integer.toString(this.masterSpreadCount));
        metadata.set("TotalPageCount", Integer.toString(this.pageCount + this.masterSpreadCount));
        xhtml.endDocument();
        if (handler.isEndDocumentWasCalled()) {
            handler.reallyEndDocument();
        }
    }

    private void handleZipStream(ZipInputStream zipStream, Metadata metadata, ParseContext context, ContentHandler handler) throws IOException, TikaException, SAXException {
        ZipEntry entry = zipStream.getNextEntry();
        if (entry == null) {
            throw new IOException("No entries found in ZipInputStream");
        }
        do {
            this.handleZipEntry(entry, zipStream, metadata, context, handler);
        } while ((entry = zipStream.getNextEntry()) != null);
    }

    private void handleZipFile(ZipFile zipFile, Metadata metadata, ParseContext context, ContentHandler handler) throws IOException, TikaException, SAXException {
        ZipEntry entry = zipFile.getEntry(META_NAME);
        if (entry != null) {
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, handler);
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (META_NAME.equals(entry.getName())) continue;
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, handler);
        }
    }

    private void handleZipEntry(ZipEntry entry, InputStream zip, Metadata metadata, ParseContext context, ContentHandler handler) throws IOException, SAXException, TikaException {
        if (entry == null) {
            return;
        }
        if (entry.getName().equals("mimetype")) {
            String type = IOUtils.toString(zip, StandardCharsets.UTF_8);
            metadata.set("Content-Type", type);
        } else if (entry.getName().equals(META_NAME)) {
            XMPMetadataExtractor.parse(zip, metadata);
        } else if (entry.getName().contains("MasterSpreads")) {
            Metadata embeddedMeta = new Metadata();
            ContentAndMetadataExtractor.extract(zip, handler, embeddedMeta, context);
            int spreadCount = Integer.parseInt(embeddedMeta.get("PageCount"));
            this.masterSpreadCount += spreadCount;
        } else if (entry.getName().contains("Spreads/Spread")) {
            Metadata embeddedMeta = new Metadata();
            ContentAndMetadataExtractor.extract(zip, handler, embeddedMeta, context);
            int spreadCount = Integer.parseInt(embeddedMeta.get("PageCount"));
            this.pageCount += spreadCount;
        } else if (entry.getName().contains("Stories")) {
            ContentAndMetadataExtractor.extract(zip, handler, new Metadata(), context);
        }
    }
}

