/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mif;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.detect.AutoDetectReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MIFExtractor {
    private static final Pattern openTagPattern = Pattern.compile("<(\\S*).*");
    private static final Pattern selfTagPattern = Pattern.compile("(<(\\S*))(\\s)(.*)(\\>).*");
    private static final String OPEN_TAG_MARKER = "<";
    private static final String CLOSE_TAG_MARKER = ">";
    private static final String START_TAG_VALUE = "`";
    private static final String END_TAG_VALUE = "'";

    static void parse(AutoDetectReader reader, ContentHandler handler) throws IOException, SAXException {
        String line;
        handler.startDocument();
        Tag currentTag = new Tag();
        Stack<Tag> parents = new Stack<Tag>();
        while ((line = reader.readLine()) != null) {
            Matcher matcher;
            if (line.contains(OPEN_TAG_MARKER) && !line.contains(CLOSE_TAG_MARKER)) {
                matcher = openTagPattern.matcher(line.trim());
                if (!matcher.matches()) continue;
                if (!parents.empty()) {
                    currentTag = new Tag();
                    currentTag.setParent((Tag)parents.peek());
                }
                currentTag.setName(matcher.group(1));
                parents.push(currentTag);
                AttributesImpl attrs = new AttributesImpl();
                handler.startElement("", matcher.group(1), matcher.group(1), attrs);
                continue;
            }
            if (line.trim().startsWith(CLOSE_TAG_MARKER)) {
                try {
                    String tmp = line.trim();
                    String tagName = tmp.substring(tmp.lastIndexOf(" ") + 1);
                    Tag parent = (Tag)parents.peek();
                    if (tagName.equals(parent.getName())) {
                        parents.pop();
                    }
                    if (!parents.empty()) {
                        ((Tag)parents.peek()).addChild(parent);
                    }
                    handler.endElement("", parent.getName(), parent.getName());
                }
                catch (EmptyStackException tmp) {}
                continue;
            }
            matcher = selfTagPattern.matcher(line.trim());
            if (!matcher.matches()) continue;
            if (!parents.empty()) {
                Tag child = new Tag();
                child.setName(matcher.group(2));
                child.setValue(matcher.group(4));
                child.setParent((Tag)parents.peek());
                currentTag.addChild(child);
                MIFExtractor.processTag(handler, child);
                continue;
            }
            currentTag.setName(matcher.group(2));
            currentTag.setValue(matcher.group(4));
            MIFExtractor.processTag(handler, currentTag);
            currentTag = new Tag();
        }
        handler.endDocument();
    }

    private static void processTag(ContentHandler handler, Tag tag) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        handler.startElement("", tag.getName(), tag.getName(), attrs);
        String value = StringUtils.removeStart(tag.getValue(), START_TAG_VALUE);
        value = StringUtils.removeEnd(value, END_TAG_VALUE);
        String content = StringEscapeUtils.escapeXml(value);
        handler.characters(content.toCharArray(), 0, content.length());
        handler.endElement("", tag.getName(), tag.getName());
    }

    private static final class Tag {
        private List<Tag> children = new ArrayList<Tag>();
        private Tag parent;
        private String name;
        private String value;

        private Tag() {
        }

        public void addChild(Tag child) {
            this.children.add(child);
        }

        public List<Tag> getChildren() {
            return this.children;
        }

        public void setChildren(List<Tag> children) {
            this.children = children;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }

        public Tag getParent() {
            return this.parent;
        }

        public void setParent(Tag parent) {
            this.parent = parent;
        }
    }
}

