/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class SenderIsRegex
extends GenericMatcher {
    private Pattern pattern;

    public void init() throws MessagingException {
        String patternString = this.getCondition();
        if (Strings.isNullOrEmpty((String)patternString)) {
            throw new MessagingException("Pattern is missing");
        }
        patternString = patternString.trim();
        try {
            this.pattern = Pattern.compile(patternString);
        }
        catch (PatternSyntaxException mpe) {
            throw new MessagingException("Malformed pattern: " + patternString, (Exception)mpe);
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        String senderString = mail.getMaybeSender().asString();
        if (this.pattern.matcher(senderString).matches()) {
            return mail.getRecipients();
        }
        return null;
    }
}

