/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Objects;

public class ProxyInformation {
    private final InetSocketAddress source;
    private final InetSocketAddress destination;

    public ProxyInformation(InetSocketAddress source, InetSocketAddress destination) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)destination);
        this.source = source;
        this.destination = destination;
    }

    public InetSocketAddress getDestination() {
        return this.destination;
    }

    public InetSocketAddress getSource() {
        return this.source;
    }

    public final int hashCode() {
        return Objects.hash(this.source, this.destination);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ProxyInformation) {
            ProxyInformation other = (ProxyInformation)obj;
            return Objects.equals(this.source, other.source) && Objects.equals(this.destination, other.destination);
        }
        return false;
    }
}

