/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresThreadDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresThreadTable.TABLE}).addIndex(new PostgresIndex[]{PostgresThreadTable.MESSAGE_ID_INDEX}).addIndex(new PostgresIndex[]{PostgresThreadTable.THREAD_ID_INDEX}).build();

    public static interface PostgresThreadTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"thread");
        public static final Field<String> USERNAME = DSL.field((String)"username", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<Integer> HASH_MIME_MESSAGE_ID = DSL.field((String)"hash_mime_message_id", (DataType)SQLDataType.INTEGER.notNull());
        public static final Field<UUID> MESSAGE_ID = DSL.field((String)"message_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<UUID> THREAD_ID = DSL.field((String)"thread_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<Integer> HASH_BASE_SUBJECT = DSL.field((String)"hash_base_subject", (DataType)SQLDataType.INTEGER);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(USERNAME).column(HASH_MIME_MESSAGE_ID).column(MESSAGE_ID).column(THREAD_ID).column(HASH_BASE_SUBJECT).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{USERNAME, HASH_MIME_MESSAGE_ID, MESSAGE_ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex MESSAGE_ID_INDEX = PostgresIndex.name((String)"thread_message_id_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USERNAME, MESSAGE_ID}));
        public static final PostgresIndex THREAD_ID_INDEX = PostgresIndex.name((String)"thread_thread_id_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USERNAME, THREAD_ID}));
    }
}

