/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.processor.AggregatorFactory;
import org.apache.jmeter.report.processor.MaxAggregatorFactory;
import org.apache.jmeter.report.processor.MedianAggregatorFactory;
import org.apache.jmeter.report.processor.MinAggregatorFactory;
import org.apache.jmeter.report.processor.PercentileAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.StaticSeriesSelector;
import org.apache.jmeter.report.processor.graph.SuccessfulElapsedTimeValueSelector;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;
import org.apache.jmeter.util.JMeterUtils;

public class ResponseTimePercentilesOverTimeGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String PCT1_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct1", "90");
    private static final String PCT2_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct2", "95");
    private static final String PCT3_LABEL = JMeterUtils.getPropDefault("aggregate_rpt_pct3", "99");

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(8);
        groupInfos.put("aggregate_report_min", ResponseTimePercentilesOverTimeGraphConsumer.createMinGroupInfo());
        groupInfos.put("aggregate_report_max", ResponseTimePercentilesOverTimeGraphConsumer.createMaxGroupInfo());
        groupInfos.put("aggregate_report_median", ResponseTimePercentilesOverTimeGraphConsumer.createMedianGroupInfo());
        groupInfos.put("aggregate_rpt_pct1", ResponseTimePercentilesOverTimeGraphConsumer.createPercentileGroupInfo("aggregate_rpt_pct1", PCT1_LABEL));
        groupInfos.put("aggregate_rpt_pct2", ResponseTimePercentilesOverTimeGraphConsumer.createPercentileGroupInfo("aggregate_rpt_pct2", PCT2_LABEL));
        groupInfos.put("aggregate_rpt_pct3", ResponseTimePercentilesOverTimeGraphConsumer.createPercentileGroupInfo("aggregate_rpt_pct3", PCT3_LABEL));
        return groupInfos;
    }

    private static String formatPercentile(String percentileLabel) {
        return String.format("%sth percentile", percentileLabel);
    }

    private static GroupInfo createMinGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Min");
        return ResponseTimePercentilesOverTimeGraphConsumer.createGroupInfo(new MinAggregatorFactory(), seriesSelector);
    }

    private static GroupInfo createMaxGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Max");
        return ResponseTimePercentilesOverTimeGraphConsumer.createGroupInfo(new MaxAggregatorFactory(), seriesSelector);
    }

    private static GroupInfo createMedianGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Median");
        return ResponseTimePercentilesOverTimeGraphConsumer.createGroupInfo(new MedianAggregatorFactory(), seriesSelector);
    }

    private static GroupInfo createPercentileGroupInfo(String propKey, String label) {
        String seriesName = ResponseTimePercentilesOverTimeGraphConsumer.formatPercentile(label);
        double defaultValue = new BigDecimal(label).setScale(2, RoundingMode.CEILING).doubleValue();
        double property = JMeterUtils.getPropDefault(propKey, defaultValue);
        PercentileAggregatorFactory factory = new PercentileAggregatorFactory();
        factory.setPercentileIndex(property);
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName(seriesName);
        return ResponseTimePercentilesOverTimeGraphConsumer.createGroupInfo(factory, seriesSelector);
    }

    private static GroupInfo createGroupInfo(AggregatorFactory aggregationFactory, StaticSeriesSelector seriesSelector) {
        return new GroupInfo(aggregationFactory, seriesSelector, new SuccessfulElapsedTimeValueSelector(), false, false);
    }
}

