/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jmeter.samplers.SampleSenderFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteListenerWrapper
extends AbstractTestElement
implements SampleListener,
TestStateListener,
Serializable,
NoThreadClone {
    private static final Logger log = LoggerFactory.getLogger(RemoteListenerWrapper.class);
    private static final long serialVersionUID = 241L;
    private final RemoteSampleListener listener;
    private final SampleSender sender;

    public RemoteListenerWrapper(RemoteSampleListener l) {
        this.listener = l;
        this.sender = SampleSenderFactory.getInstance(this.listener);
    }

    public RemoteListenerWrapper() {
        this.listener = null;
        this.sender = null;
    }

    @Override
    public void testStarted() {
        log.debug("Test Started()");
        try {
            this.listener.testStarted();
        }
        catch (Error | RuntimeException ex) {
            log.error("testStarted()", ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("testStarted()", (Throwable)ex);
        }
    }

    @Override
    public void testEnded() {
        this.sender.testEnded();
    }

    @Override
    public void testStarted(String host) {
        log.debug("Test Started on {}", (Object)host);
        try {
            this.listener.testStarted(host);
        }
        catch (Error | RuntimeException ex) {
            log.error("testStarted(host) on {}", (Object)host, (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("testStarted(host) on {}", (Object)host, (Object)ex);
        }
    }

    @Override
    public void testEnded(String host) {
        this.sender.testEnded(host);
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        this.sender.sampleOccurred(e);
    }

    @Override
    public void sampleStarted(SampleEvent e) {
        log.debug("Sample started");
        try {
            this.listener.sampleStarted(e);
        }
        catch (RemoteException err) {
            log.error("sampleStarted", (Throwable)err);
        }
    }

    @Override
    public void sampleStopped(SampleEvent e) {
        log.debug("Sample stopped");
        try {
            this.listener.sampleStopped(e);
        }
        catch (RemoteException err) {
            log.error("sampleStopped", (Throwable)err);
        }
    }
}

