/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.JTextComponentBinding;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.AbstractThreadGroupSchema;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.ThreadGroupSchema;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JEditableCheckBox;

@TestElementMetadata(labelResource="threadgroup")
public class ThreadGroupGui
extends AbstractThreadGroupGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private LoopControlPanel loopPanel;
    private static final String THREAD_NAME = "Thread Field";
    private static final String RAMP_NAME = "Ramp Up Field";
    private final JTextField threadInput = new JTextField();
    private final JTextField rampInput = new JTextField();
    private final boolean showDelayedStart;
    private JBooleanPropertyEditor delayedStart;
    private final JBooleanPropertyEditor scheduler = new JBooleanPropertyEditor(ThreadGroupSchema.INSTANCE.getUseScheduler(), JMeterUtils.getResString("scheduler"));
    private final JTextField duration = new JTextField();
    private final JLabel durationLabel = JMeterUtils.labelFor(this.duration, "duration");
    private final JTextField delay = new JTextField();
    private final JLabel delayLabel = JMeterUtils.labelFor(this.delay, "delay");
    private final JBooleanPropertyEditor sameUserBox = new JBooleanPropertyEditor(AbstractThreadGroupSchema.INSTANCE.getSameUserOnNextIteration(), JMeterUtils.getResString("threadgroup_same_user"));

    public ThreadGroupGui() {
        this(true);
    }

    public ThreadGroupGui(boolean showDelayedStart) {
        this.showDelayedStart = showDelayedStart;
        this.init();
        this.initGui();
        if (showDelayedStart) {
            this.bindingGroup.add(this.delayedStart);
        }
        this.bindingGroup.addAll(Arrays.asList(new JTextComponentBinding(this.threadInput, AbstractThreadGroupSchema.INSTANCE.getNumThreads()), new JTextComponentBinding(this.rampInput, ThreadGroupSchema.INSTANCE.getRampTime()), new JTextComponentBinding(this.duration, ThreadGroupSchema.INSTANCE.getDuration()), new JTextComponentBinding(this.delay, ThreadGroupSchema.INSTANCE.getDelay()), this.sameUserBox, this.scheduler));
    }

    @Override
    public TestElement makeTestElement() {
        return new ThreadGroup();
    }

    @Override
    public void assignDefaultValues(TestElement element) {
        super.assignDefaultValues(element);
        element.set(ThreadGroupSchema.INSTANCE.getNumThreads(), 1);
        element.set(ThreadGroupSchema.INSTANCE.getRampTime(), 1);
        element.set(AbstractThreadGroupSchema.INSTANCE.getSameUserOnNextIteration(), true);
        ((AbstractThreadGroup)element).setSamplerController((LoopController)this.loopPanel.createTestElement());
    }

    @Override
    public void modifyTestElement(TestElement tg) {
        super.modifyTestElement(tg);
        if (tg instanceof AbstractThreadGroup) {
            ((AbstractThreadGroup)tg).setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        this.loopPanel.configure((TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue());
        this.toggleSchedulerFields();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
    }

    private void toggleSchedulerFields() {
        boolean enable = !this.scheduler.getValue().equals(JEditableCheckBox.Value.of((boolean)false));
        this.duration.setEnabled(enable);
        this.durationLabel.setEnabled(enable);
        this.delay.setEnabled(enable);
        this.delayLabel.setEnabled(enable);
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(1);
        this.loopPanel.configure(looper);
        return this.loopPanel;
    }

    @Override
    public String getLabelResource() {
        return "threadgroup";
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void initGui() {
        this.loopPanel.clearGui();
    }

    private void init() {
        JPanel threadPropsPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        threadPropsPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("thread_properties")));
        threadPropsPanel.add(JMeterUtils.labelFor(this.threadInput, "number_of_threads"));
        this.threadInput.setName(THREAD_NAME);
        threadPropsPanel.add(this.threadInput);
        threadPropsPanel.add(JMeterUtils.labelFor(this.rampInput, "ramp_up"));
        this.rampInput.setName(RAMP_NAME);
        threadPropsPanel.add(this.rampInput);
        LoopControlPanel loopController = (LoopControlPanel)this.createControllerPanel();
        threadPropsPanel.add((Component)loopController.getLoopsLabel(), "split 2");
        threadPropsPanel.add((Component)loopController.getInfinite(), "gapleft push");
        threadPropsPanel.add(loopController.getLoops());
        threadPropsPanel.add((Component)((Object)this.sameUserBox), "span 2");
        if (this.showDelayedStart) {
            this.delayedStart = new JBooleanPropertyEditor(ThreadGroupSchema.INSTANCE.getDelayedStart(), JMeterUtils.getResString("delayed_start"));
            threadPropsPanel.add((Component)((Object)this.delayedStart), "span 2");
        }
        this.scheduler.addPropertyChangeListener("value", ev -> this.toggleSchedulerFields());
        threadPropsPanel.add((Component)((Object)this.scheduler), "span 2");
        threadPropsPanel.add(this.durationLabel);
        threadPropsPanel.add(this.duration);
        threadPropsPanel.add(this.delayLabel);
        threadPropsPanel.add(this.delay);
        this.add((Component)threadPropsPanel, "Center");
    }
}

