/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.mapping.framework;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.event.ListenerCaller;
import org.jetbrains.letsPlot.commons.intern.observable.event.Listeners;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mappers;
import org.jetbrains.letsPlot.datamodel.mapping.framework.MappingContextListener;
import org.jetbrains.letsPlot.datamodel.mapping.framework.MappingContextProperty;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\tJ\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t\u00a2\u0006\u0002\u0010\u0012J9\u0010\u0013\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00140\u001aJ/\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0017\u001a\u0002H\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ=\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0000\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00140\u001a\"\u0004\b\u0000\u0010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u0002H\u0015\u00a2\u0006\u0002\u0010\u001cJ)\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\t2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u0011\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014J\u001f\u0010#\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010$\u001a\u00020\u001e2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0001\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContext;", "", "()V", "myListeners", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/Listeners;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContextListener;", "myMappers", "", "myProperties", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContextProperty;", "addListener", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "l", "contains", "", "property", "get", "ValueT", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContextProperty;)Ljava/lang/Object;", "getMapper", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "S", "ancestor", "source", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;Ljava/lang/Object;)Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "getMappers", "", "(Ljava/lang/Object;)Ljava/util/Set;", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;Ljava/lang/Object;)Ljava/util/Set;", "put", "", "value", "(Lorg/jetbrains/letsPlot/datamodel/mapping/framework/MappingContextProperty;Ljava/lang/Object;)V", "register", "mapper", "remove", "unregister", "datamodel"})
public final class MappingContext {
    @NotNull
    private final Map<? super Object, ? super Object> myMappers = new LinkedHashMap();
    @NotNull
    private final Listeners<MappingContextListener> myListeners = new Listeners();
    @NotNull
    private final Map<MappingContextProperty<?>, Object> myProperties = new LinkedHashMap();

    @NotNull
    public final Registration addListener(@NotNull MappingContextListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return this.myListeners.add((Object)l);
    }

    public final void register(@NotNull Mapper<?, ?> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (mapper.isFindable()) {
            Object source = mapper.getSource();
            if (!this.myMappers.containsKey(source)) {
                this.myMappers.put(source, mapper);
            } else {
                Object ms = this.myMappers.get(source);
                if (ms instanceof Set) {
                    Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                    mappers.add(mapper);
                } else {
                    Intrinsics.checkNotNull((Object)ms, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper<*, *>");
                    Mapper m = (Mapper)ms;
                    Object[] objectArray = new Mapper[]{m, mapper};
                    Set mappers = SetsKt.mutableSetOf((Object[])objectArray);
                    this.myMappers.put(source, mappers);
                }
            }
        }
        this.myListeners.fire((ListenerCaller)new ListenerCaller<MappingContextListener>(mapper){
            final /* synthetic */ Mapper<?, ?> $mapper;
            {
                this.$mapper = $mapper;
            }

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperRegistered(this.$mapper);
            }
        });
    }

    public final void unregister(@NotNull Mapper<?, ?> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (mapper.isFindable()) {
            Object source = mapper.getSource();
            if (!this.myMappers.containsKey(source)) {
                throw new IllegalStateException();
            }
            Object ms = this.myMappers.get(source);
            if (ms instanceof Set) {
                Set mappers = TypeIntrinsics.asMutableSet((Object)ms);
                mappers.remove(mapper);
                if (mappers.size() == 1) {
                    this.myMappers.put(source, mappers.iterator().next());
                }
            } else {
                if (!Intrinsics.areEqual((Object)ms, mapper)) {
                    throw new IllegalStateException();
                }
                this.myMappers.remove(source);
            }
        }
        this.myListeners.fire((ListenerCaller)new ListenerCaller<MappingContextListener>(mapper){
            final /* synthetic */ Mapper<?, ?> $mapper;
            {
                this.$mapper = $mapper;
            }

            public void call(@NotNull MappingContextListener l) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                l.onMapperUnregistered(this.$mapper);
            }
        });
    }

    @Nullable
    public final <S> Mapper<? super S, Object> getMapper(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> result = this.getMappers(ancestor, source);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new IllegalStateException("There are more than one mapper for " + source);
        }
        return result.iterator().next();
    }

    @NotNull
    public final <S> Set<Mapper<? super S, Object>> getMappers(@NotNull Mapper<?, ?> ancestor, S source) {
        Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
        Set<Mapper<S, Object>> mappers = this.getMappers(source);
        Set result = null;
        for (Mapper<S, Object> m : mappers) {
            if (!Mappers.INSTANCE.isDescendant(ancestor, m)) continue;
            if (result == null) {
                if (mappers.size() == 1) {
                    return SetsKt.setOf(m);
                }
                result = new LinkedHashSet();
            }
            result.add(m);
        }
        if (result == null) {
            return SetsKt.emptySet();
        }
        return result;
    }

    public final <ValueT> void put(@NotNull MappingContextProperty<ValueT> property, @Nullable ValueT value) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.myProperties.containsKey(property)) {
            throw new IllegalStateException("Property " + property + " is already defined");
        }
        if (value == null) {
            throw new IllegalArgumentException("Trying to set null as a value of " + property);
        }
        this.myProperties.put(property, value);
    }

    public final <ValueT> ValueT get(@NotNull MappingContextProperty<ValueT> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Object object = this.myProperties.get(property);
        if (object == null) {
            throw new IllegalStateException("Property " + property + " wasn't found");
        }
        Object value = object;
        return (ValueT)value;
    }

    public final boolean contains(@NotNull MappingContextProperty<Object> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.myProperties.containsKey(property);
    }

    public final <ValueT> ValueT remove(@NotNull MappingContextProperty<Object> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (!this.myProperties.containsKey(property)) {
            throw new IllegalStateException("Property " + property + " wasn't found");
        }
        return (ValueT)this.myProperties.remove(property);
    }

    @NotNull
    public final Set<Mapper<? super Object, Object>> getMappers() {
        Set mappers = new LinkedHashSet();
        for (Object object : this.myMappers.keySet()) {
            mappers.addAll((Collection)this.getMappers(object));
        }
        return mappers;
    }

    private final <S> Set<Mapper<? super S, Object>> getMappers(S source) {
        if (!this.myMappers.containsKey(source)) {
            return SetsKt.emptySet();
        }
        Object mappersObject = this.myMappers.get(source);
        if (mappersObject instanceof Mapper) {
            Mapper mapper = (Mapper)mappersObject;
            return SetsKt.setOf((Object)mapper);
        }
        Set result = new LinkedHashSet();
        Intrinsics.checkNotNull((Object)mappersObject, (String)"null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper<in S of org.jetbrains.letsPlot.datamodel.mapping.framework.MappingContext.getMappers, kotlin.Any>>");
        Set mapperSet = (Set)mappersObject;
        for (Mapper m : mapperSet) {
            result.add(m);
        }
        return result;
    }
}

