/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.data.OrderOptionUtil;
import org.jetbrains.letsPlot.core.plot.builder.scale.MapperProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProvider;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.GeomProto;
import org.jetbrains.letsPlot.core.spec.Option;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.core.spec.PlotConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.CoordConfig;
import org.jetbrains.letsPlot.core.spec.config.DataMetaUtil;
import org.jetbrains.letsPlot.core.spec.config.FacetConfig;
import org.jetbrains.letsPlot.core.spec.config.FontFamilyRegistryConfig;
import org.jetbrains.letsPlot.core.spec.config.LayerConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.PlotConfigMapperProviders;
import org.jetbrains.letsPlot.core.spec.config.PlotConfigScaleProviders;
import org.jetbrains.letsPlot.core.spec.config.PlotConfigTransforms;
import org.jetbrains.letsPlot.core.spec.config.ScaleConfig;
import org.jetbrains.letsPlot.core.spec.config.ThemeConfig;
import org.jetbrains.letsPlot.core.spec.conversion.AesOptionConversion;
import org.jetbrains.letsPlot.core.spec.conversion.ColorOptionConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 C2\u00020\u0001:\u0001CB+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJj\u00108\u001a\u00020\u001b2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010+\u001a\u00020*2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010>\u001a\u00020\tH\u0002J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010+\u001a\u00020*2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020*H\u0004R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001dR$\u0010&\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u00020'0\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u001e\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u0011\u00100\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u00103\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0011R$\u00105\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0004\u0012\u0002060\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\"\u00a8\u0006D"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/PlotConfig;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "opts", "", "", "", "containerTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "isClientSide", "", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "aopConversion", "Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "getAopConversion", "()Lorg/jetbrains/letsPlot/core/spec/conversion/AesOptionConversion;", "caption", "getCaption", "()Ljava/lang/String;", "containsLiveMap", "getContainsLiveMap", "()Z", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "getFacets", "()Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "layerConfigs", "", "Lorg/jetbrains/letsPlot/core/spec/config/LayerConfig;", "getLayerConfigs", "()Ljava/util/List;", "mapperProviderByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/MapperProvider;", "getMapperProviderByAes", "()Ljava/util/Map;", "scaleConfigs", "Lorg/jetbrains/letsPlot/core/spec/config/ScaleConfig;", "getScaleConfigs", "scaleProviderByAes", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProvider;", "getScaleProviderByAes", "<set-?>", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "sharedData", "getSharedData", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "subtitle", "getSubtitle", "theme", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "title", "getTitle", "transformByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "getTransformByAes", "createLayerConfig", "layerOptions", "plotMappings", "plotDataMeta", "plotOrderOptions", "Lorg/jetbrains/letsPlot/core/plot/builder/data/OrderOptionUtil$OrderOption;", "isMapPlot", "createLayerConfigs", "replaceSharedData", "", "plotData", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nPlotConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotConfig.kt\norg/jetbrains/letsPlot/core/spec/config/PlotConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,225:1\n1747#2,3:226\n1603#2,9:229\n1855#2:238\n1856#2:240\n1612#2:241\n1549#2:242\n1620#2,3:243\n1747#2,3:246\n1238#2,4:252\n1#3:239\n1#3:249\n453#4:250\n403#4:251\n*S KotlinDebug\n*F\n+ 1 PlotConfig.kt\norg/jetbrains/letsPlot/core/spec/config/PlotConfig\n*L\n61#1:226,3\n132#1:229,9\n132#1:238\n132#1:240\n132#1:241\n133#1:242\n133#1:243,3\n134#1:246,3\n144#1:252,4\n132#1:239\n144#1:250\n144#1:251\n*E\n"})
public abstract class PlotConfig
extends OptionsAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isClientSide;
    @NotNull
    private final Theme theme;
    @NotNull
    private final AesOptionConversion aopConversion;
    @NotNull
    private final List<LayerConfig> layerConfigs;
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final List<ScaleConfig<?>> scaleConfigs;
    @NotNull
    private final Map<Aes<?>, MapperProvider<?>> mapperProviderByAes;
    @NotNull
    private final Map<Aes<?>, ScaleProvider> scaleProviderByAes;
    @NotNull
    private final Map<Aes<?>, Transform> transformByAes;
    @NotNull
    private DataFrame sharedData;
    @NotNull
    private static final String ERROR_MESSAGE = "__error_message";
    @NotNull
    private static final Map<String, Object> DEF_OPTIONS = MapsKt.emptyMap();
    @NotNull
    public static final String PLOT_COMPUTATION_MESSAGES = "computation_messages";

    public PlotConfig(@NotNull Map<String, ? extends Object> opts, @Nullable Theme containerTheme, boolean isClientSide) {
        PlotFacets plotFacets;
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        super(opts, DEF_OPTIONS);
        this.isClientSide = isClientSide;
        FontFamilyRegistry fontFamilyRegistry = new FontFamilyRegistryConfig(this).createFontFamilyRegistry();
        Theme ownTheme = new ThemeConfig(this.getMap("theme"), fontFamilyRegistry).getTheme();
        this.theme = containerTheme == null || this.hasOwn("theme") ? ownTheme : ownTheme.toInherited(containerTheme);
        this.aopConversion = new AesOptionConversion(new ColorOptionConverter(this.theme.colors().pen(), this.theme.colors().paper(), this.theme.colors().brush()));
        this.sharedData = ConfigUtil.INSTANCE.createDataFrame$plot_stem(this.get("data"));
        this.layerConfigs = this.createLayerConfigs(this.sharedData, this.isClientSide);
        boolean excludeStatVariables = !this.isClientSide;
        this.scaleConfigs = PlotConfigUtil.INSTANCE.createScaleConfigs$plot_stem(CollectionsKt.plus((Collection)DataMetaUtil.INSTANCE.createScaleSpecs(opts), (Iterable)this.getList("scales")), this.aopConversion);
        this.mapperProviderByAes = PlotConfigMapperProviders.INSTANCE.createMapperProviders$plot_stem(this.layerConfigs, this.scaleConfigs, excludeStatVariables);
        boolean zeroPositionalExpands = !CoordConfig.INSTANCE.allowsDomainExpand(this.get("coord"));
        this.scaleProviderByAes = PlotConfigScaleProviders.INSTANCE.createScaleProviders$plot_stem(this.layerConfigs, this.scaleConfigs, excludeStatVariables, zeroPositionalExpands);
        this.transformByAes = PlotConfigTransforms.INSTANCE.createTransforms$plot_stem(this.layerConfigs, this.scaleProviderByAes, this.mapperProviderByAes, excludeStatVariables);
        PlotConfig plotConfig = this;
        if (this.has("facet")) {
            Map<String, Object> facetOptions = this.getMap("facet");
            FacetConfig facetConfig = new FacetConfig(facetOptions);
            ArrayList<DataFrame> dataByLayer = new ArrayList<DataFrame>();
            Iterator<LayerConfig> iterator = this.layerConfigs.iterator();
            PlotConfig plotConfig2 = plotConfig;
            while (iterator.hasNext()) {
                LayerConfig layerConfig = iterator.next();
                dataByLayer.add(layerConfig.getCombinedData());
            }
            plotConfig = plotConfig2;
            plotFacets = facetConfig.createFacets((List<DataFrame>)dataByLayer);
        } else {
            plotFacets = PlotFacets.Companion.undefined();
        }
        plotConfig.facets = plotFacets;
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    @NotNull
    public final AesOptionConversion getAopConversion() {
        return this.aopConversion;
    }

    @NotNull
    public final List<LayerConfig> getLayerConfigs() {
        return this.layerConfigs;
    }

    @NotNull
    public final PlotFacets getFacets() {
        return this.facets;
    }

    @NotNull
    protected final List<ScaleConfig<?>> getScaleConfigs() {
        return this.scaleConfigs;
    }

    @NotNull
    protected final Map<Aes<?>, MapperProvider<?>> getMapperProviderByAes() {
        return this.mapperProviderByAes;
    }

    @NotNull
    protected final Map<Aes<?>, ScaleProvider> getScaleProviderByAes() {
        return this.scaleProviderByAes;
    }

    @NotNull
    protected final Map<Aes<?>, Transform> getTransformByAes() {
        return this.transformByAes;
    }

    @NotNull
    protected final DataFrame getSharedData() {
        return this.sharedData;
    }

    @Nullable
    public final String getTitle() {
        return (String)this.getMap("ggtitle").get("text");
    }

    @Nullable
    public final String getSubtitle() {
        return (String)this.getMap("ggtitle").get("subtitle");
    }

    @Nullable
    public final String getCaption() {
        return (String)this.getMap("caption").get("text");
    }

    public final boolean getContainsLiveMap() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.layerConfigs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LayerConfig p0 = (LayerConfig)element$iv;
                    boolean bl2 = false;
                    if (!p0.isLiveMap()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LayerConfig> createLayerConfigs(DataFrame sharedData, boolean isClientSide) {
        boolean bl;
        Object object;
        Object object2;
        List<?> layerOptionsList;
        ArrayList<LayerConfig> layerConfigs;
        block10: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            layerConfigs = new ArrayList<LayerConfig>();
            layerOptionsList = this.getList("layers");
            Iterable iterable = layerOptionsList;
            boolean $i$f$mapNotNull22 = false;
            void var8_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object layerOptions = element$iv$iv;
                boolean bl3 = false;
                Map map2 = layerOptions instanceof Map ? (Map)layerOptions : null;
                if (map2 != null) {
                    object2 = new String[]{"geom"};
                    string = OptionsSelectorKt.getString(map2, (String[])object2);
                } else {
                    string = null;
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            Option.GeomName $i$f$mapNotNull22 = Option.GeomName.INSTANCE;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                element$iv$iv$iv = (String)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl5 = false;
                object.add($i$f$mapNotNull22.toGeomKind((String)p0));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomKind it = (GeomKind)element$iv;
                    boolean bl6 = false;
                    Object[] $i$f$forEach2 = new GeomKind[]{GeomKind.LIVE_MAP, GeomKind.MAP};
                    if (!CollectionsKt.listOf((Object[])$i$f$forEach2).contains(it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean isMapPlot = bl;
        for (Object layerOptions : layerOptionsList) {
            Object object3;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            if (!(layerOptions instanceof Map)) {
                boolean $i$a$-require-PlotConfig$createLayerConfigs$22 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Layer options: expected Map but was ");
                Object e = layerOptions;
                Intrinsics.checkNotNull(e);
                String $i$a$-require-PlotConfig$createLayerConfigs$22 = stringBuilder.append(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName()).toString();
                throw new IllegalArgumentException($i$a$-require-PlotConfig$createLayerConfigs$22.toString());
            }
            Intrinsics.checkNotNull(layerOptions, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map cfr_ignored_0 = (Map)layerOptions;
            Map<String, Object> $i$a$-require-PlotConfig$createLayerConfigs$22 = this.getMap("mapping");
            DataFrame dataFrame = sharedData;
            Map map3 = (Map)layerOptions;
            object = this;
            boolean $i$f$mapValues = false;
            void bl6 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
                object2 = destination$iv$iv;
                boolean bl7 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object3 = object2;
                boolean bl8 = false;
                Object variable = entry.getValue();
                Intrinsics.checkNotNull(variable, (String)"null cannot be cast to non-null type kotlin.String");
                String string = (String)variable;
                object3.put(k, string);
            }
            object3 = destination$iv$iv;
            LayerConfig layerConfig = super.createLayerConfig(map3, dataFrame, (Map<String, String>)object3, this.getMap("data_meta"), DataMetaUtil.INSTANCE.getOrderOptions(this.toMap(), this.getMap("mapping"), isClientSide), isClientSide, isMapPlot);
            layerConfigs.add(layerConfig);
        }
        return layerConfigs;
    }

    private final LayerConfig createLayerConfig(Map<String, ? extends Object> layerOptions, DataFrame sharedData, Map<String, String> plotMappings, Map<String, ? extends Object> plotDataMeta, List<OrderOptionUtil.OrderOption> plotOrderOptions, boolean isClientSide, boolean isMapPlot) {
        Object object = layerOptions.get("geom");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String geomName = (String)object;
        GeomKind geomKind = Option.GeomName.INSTANCE.toGeomKind(geomName);
        GeomProto geomProto = new GeomProto(geomKind);
        return new LayerConfig(layerOptions, sharedData, plotMappings, plotDataMeta, plotOrderOptions, geomProto, this.aopConversion, isClientSide, isMapPlot);
    }

    protected final void replaceSharedData(@NotNull DataFrame plotData) {
        Intrinsics.checkNotNullParameter((Object)plotData, (String)"plotData");
        if (!(!this.isClientSide)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.sharedData = plotData;
        this.update("data", DataFrameUtil.INSTANCE.toMap(plotData));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002J\u001a\u0010\u000b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004J\u001a\u0010\u0012\u001a\u00020\u00132\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/PlotConfig$Companion;", "", "()V", "DEF_OPTIONS", "", "", "ERROR_MESSAGE", "PLOT_COMPUTATION_MESSAGES", "assertFigSpec", "", "opts", "assertFigSpecOrErrorMessage", "failure", "message", "figSpecKind", "Lorg/jetbrains/letsPlot/core/spec/FigKind;", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "getErrorMessage", "isFailure", "", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> failure(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)PlotConfig.ERROR_MESSAGE, (Object)message));
        }

        public final void assertFigSpecOrErrorMessage(@NotNull Map<String, ? extends Object> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            if (!this.isFailure(opts)) {
                this.assertFigSpec(opts);
            }
        }

        private final void assertFigSpec(Map<String, ? extends Object> opts) {
            this.figSpecKind(opts);
        }

        public final boolean isFailure(@NotNull Map<String, ? extends Object> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return opts.containsKey(PlotConfig.ERROR_MESSAGE);
        }

        @NotNull
        public final String getErrorMessage(@NotNull Map<String, ? extends Object> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            return String.valueOf(opts.get(PlotConfig.ERROR_MESSAGE));
        }

        @NotNull
        public final FigKind figSpecKind(@NotNull Map<?, ?> opts) {
            Intrinsics.checkNotNullParameter(opts, (String)"opts");
            Object obj = opts.get("kind");
            return FigKind.Companion.fromOption(obj != null ? obj.toString() : null);
        }

        @NotNull
        public final FigKind figSpecKind(@NotNull OptionsAccessor opts) {
            Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
            return FigKind.Companion.fromOption(opts.getStringSafe("kind"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

