/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import org.jCharts.axisChart.ScatterPlotAxisChart;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.ScatterPlotDataSeries;
import org.jCharts.chartData.ScatterPlotDataSet;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.properties.PointChartProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.ScatterPlotProperties;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.ScatterChartTestBase;
import org.jCharts.test.TestDataGenerator;

public class ScatterPlotTestDriver
extends ScatterChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    private ScatterPlotProperties getScatterPlotProperties(int n) {
        Stroke[] strokeArray = new Stroke[n];
        int n2 = 0;
        while (n2 < n) {
            strokeArray[n2] = LineChartProperties.DEFAULT_LINE_STROKE;
            ++n2;
        }
        strokeArray[0] = new BasicStroke(3.0f);
        Shape[] shapeArray = new Shape[n];
        int n3 = 0;
        while (n3 < n) {
            shapeArray[n3] = PointChartProperties.SHAPE_DIAMOND;
            ++n3;
        }
        shapeArray[0] = PointChartProperties.SHAPE_CIRCLE;
        return new ScatterPlotProperties(strokeArray, shapeArray);
    }

    private ScatterPlotDataSet createScatterPlotDataSet(int n, int n2, int n3, int n4, int n5, int n6) throws ChartDataException {
        Point2D.Double[] doubleArray = new Point2D.Double[n2];
        int n7 = 0;
        while (n7 < n2) {
            doubleArray[n7] = new Point2D.Double();
            doubleArray[n7].setLocation(n7, Math.pow(n7, 2.0));
            ++n7;
        }
        String[] stringArray = TestDataGenerator.getRandomStrings(n, 12, false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        Paint paint = TestDataGenerator.getRandomPaint();
        ScatterPlotDataSet scatterPlotDataSet = new ScatterPlotDataSet(this.getScatterPlotProperties(1));
        scatterPlotDataSet.addDataPoints(doubleArray, paint, stringArray[0]);
        return scatterPlotDataSet;
    }

    ScatterPlotDataSeries getDataSeries() throws ChartDataException {
        ScatterPlotDataSeries scatterPlotDataSeries = null;
        int n = (int)TestDataGenerator.getRandomNumber(3.0, 10.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 1.0);
        ScatterPlotDataSet scatterPlotDataSet = this.createScatterPlotDataSet(n2, n, 50, 50, 0, 0);
        String[] stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(10.0), false);
        String string = TestDataGenerator.getRandomString(15, true);
        String string2 = TestDataGenerator.getRandomString(15, true);
        scatterPlotDataSeries = new ScatterPlotDataSeries(scatterPlotDataSet, string, string2, "This is a test title that is so freaking long is is going to wrap around the image for sure. lfksjg;ljs; dflgkjdfgsdgdg dsgdsgsdfg dsfgsdfgsdfgs dfgdsfgd");
        scatterPlotDataSeries.addIAxisPlotDataSet(scatterPlotDataSet);
        return scatterPlotDataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        ScatterPlotTestDriver scatterPlotTestDriver = new ScatterPlotTestDriver();
        ScatterPlotDataSet scatterPlotDataSet = scatterPlotTestDriver.createScatterPlotDataSet(1, 5, -1000, 3000, 200, 500);
        ScatterPlotDataSeries scatterPlotDataSeries = new ScatterPlotDataSeries(scatterPlotDataSet, "X-Axis Title", "Y-Axis Title", "Chart Title");
        DataAxisProperties dataAxisProperties = new DataAxisProperties();
        dataAxisProperties.setUserDefinedScale(-5.0, 3.0);
        dataAxisProperties.setNumItems(10);
        dataAxisProperties.setRoundToNearest(0);
        DataAxisProperties dataAxisProperties2 = new DataAxisProperties();
        dataAxisProperties2.setUserDefinedScale(-30.0, 50.0);
        dataAxisProperties2.setNumItems(10);
        dataAxisProperties2.setRoundToNearest(1);
        AxisProperties axisProperties = new AxisProperties(dataAxisProperties, dataAxisProperties2);
        ChartProperties chartProperties = new ChartProperties();
        LegendProperties legendProperties = new LegendProperties();
        ScatterPlotAxisChart scatterPlotAxisChart = new ScatterPlotAxisChart(scatterPlotDataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(scatterPlotAxisChart, "ScatterPlotTest.png");
    }
}

