/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLCollection
implements Iterable<URL> {
    private static final Logger log = LoggerFactory.getLogger(URLCollection.class);
    private final Collection<URLString> coll;

    public URLCollection(Collection<URLString> c) {
        this.coll = Objects.requireNonNull(c, "collection must not be null");
    }

    public boolean add(URL u) {
        return this.coll.add(new URLString(u));
    }

    public boolean addURL(String url, URL baseUrl) {
        boolean b;
        if (url == null || url.length() == 0) {
            return false;
        }
        url = StringEscapeUtils.unescapeXml((String)url);
        try {
            b = this.add(ConversionUtils.makeRelativeURL(baseUrl, url));
        }
        catch (MalformedURLException mfue) {
            if (log.isDebugEnabled()) {
                log.debug("Error occurred building relative url for: {}, message: {}", (Object)url, (Object)mfue.getMessage());
            }
            return false;
        }
        return b;
    }

    @Override
    public Iterator<URL> iterator() {
        return new UrlIterator(this.coll.iterator());
    }

    private static class UrlIterator
    implements Iterator<URL> {
        private final Iterator<? extends URLString> iter;

        UrlIterator(Iterator<? extends URLString> i) {
            this.iter = i;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public URL next() {
            return this.iter.next().getURL();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

