/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.HTTPConstantsInterface;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;

public abstract class HTTPAbstractImpl
implements Interruptible,
HTTPConstantsInterface {
    protected static final boolean ADD_CONTENT_TYPE_TO_POST_IF_MISSING = JMeterUtils.getPropDefault((String)"http.post_add_content_type_if_missing", (boolean)false);
    private static final CachedResourceMode CACHED_RESOURCE_MODE = CachedResourceMode.valueOf(JMeterUtils.getPropDefault((String)"cache_manager.cached_resource_mode", (String)CachedResourceMode.RETURN_NO_SAMPLE.toString()));
    private static final String RETURN_200_CACHE_MESSAGE = JMeterUtils.getPropDefault((String)"RETURN_200_CACHE.message", (String)"(ex cache)");
    private static final String RETURN_CUSTOM_STATUS_CODE = JMeterUtils.getProperty((String)"RETURN_CUSTOM_STATUS.code");
    protected static final Predicate<String> ALL_EXCEPT_COOKIE = s -> !"Cookie".equalsIgnoreCase((String)s);
    protected static final Predicate<String> ONLY_COOKIE = s -> "Cookie".equalsIgnoreCase((String)s);
    private static final String RETURN_CUSTOM_STATUS_MESSAGE = JMeterUtils.getProperty((String)"RETURN_CUSTOM_STATUS.message");
    protected final HTTPSamplerBase testElement;

    protected HTTPAbstractImpl(HTTPSamplerBase testElement) {
        this.testElement = testElement;
    }

    protected abstract HTTPSampleResult sample(URL var1, String var2, boolean var3, int var4);

    protected void threadFinished() {
    }

    protected void notifyFirstSampleAfterLoopRestart() {
    }

    protected HTTPSampleResult errorResult(Throwable t, HTTPSampleResult res) {
        return this.testElement.errorResult(t, res);
    }

    protected Arguments getArguments() {
        return this.testElement.getArguments();
    }

    protected AuthManager getAuthManager() {
        return this.testElement.getAuthManager();
    }

    protected boolean getAutoRedirects() {
        return this.testElement.getAutoRedirects();
    }

    protected CacheManager getCacheManager() {
        return this.testElement.getCacheManager();
    }

    protected int getConnectTimeout() {
        return this.testElement.getConnectTimeout();
    }

    protected String getContentEncoding() {
        return this.testElement.getContentEncoding();
    }

    protected CookieManager getCookieManager() {
        return this.testElement.getCookieManager();
    }

    protected HeaderManager getHeaderManager() {
        return this.testElement.getHeaderManager();
    }

    protected HTTPFileArg[] getHTTPFiles() {
        return this.testElement.getHTTPFiles();
    }

    protected String getIpSource() {
        return this.testElement.getIpSource();
    }

    protected InetAddress getIpSourceAddress() throws UnknownHostException, SocketException {
        String ipSource = this.getIpSource();
        if (ipSource.trim().length() > 0) {
            Class<InetAddress> ipClass = null;
            HTTPSamplerBase.SourceType sourceType = HTTPSamplerBase.SourceType.values()[this.testElement.getIpSourceType()];
            switch (sourceType) {
                case DEVICE: {
                    ipClass = InetAddress.class;
                    break;
                }
                case DEVICE_IPV4: {
                    ipClass = Inet4Address.class;
                    break;
                }
                case DEVICE_IPV6: {
                    ipClass = Inet6Address.class;
                    break;
                }
                case HOSTNAME: {
                    return InetAddress.getByName(ipSource);
                }
            }
            NetworkInterface net = NetworkInterface.getByName(ipSource);
            if (net != null) {
                for (InterfaceAddress ia : net.getInterfaceAddresses()) {
                    InetAddress inetAddr = ia.getAddress();
                    if (!ipClass.isInstance(inetAddr)) continue;
                    return inetAddr;
                }
                throw new UnknownHostException("Interface " + ipSource + " does not have address of type " + ipClass.getSimpleName());
            }
            throw new UnknownHostException("Cannot find interface " + ipSource);
        }
        return null;
    }

    protected String getProxyScheme() {
        return this.testElement.getProxyScheme();
    }

    protected String getProxyHost() {
        return this.testElement.getProxyHost();
    }

    protected String getProxyPass() {
        return this.testElement.getProxyPass();
    }

    protected int getProxyPortInt() {
        return this.testElement.getProxyPortInt();
    }

    protected String getProxyUser() {
        return this.testElement.getProxyUser();
    }

    protected int getResponseTimeout() {
        return this.testElement.getResponseTimeout();
    }

    protected boolean getSendFileAsPostBody() {
        return this.testElement.getSendFileAsPostBody();
    }

    protected boolean getSendParameterValuesAsPostBody() {
        return this.testElement.getSendParameterValuesAsPostBody();
    }

    protected boolean getUseKeepAlive() {
        return this.testElement.getUseKeepAlive();
    }

    @Deprecated
    protected boolean getUseMultipartForPost() {
        return this.testElement.getUseMultipartForPost();
    }

    protected boolean getUseMultipart() {
        return this.testElement.getUseMultipart();
    }

    protected boolean getDoBrowserCompatibleMultipart() {
        return this.testElement.getDoBrowserCompatibleMultipart();
    }

    protected boolean hasArguments() {
        return this.testElement.hasArguments();
    }

    @Deprecated
    protected boolean isMonitor() {
        return false;
    }

    protected boolean isSuccessCode(int errorLevel) {
        return this.testElement.isSuccessCode(errorLevel);
    }

    protected byte[] readResponse(SampleResult res, InputStream instream, int responseContentLength) throws IOException {
        return this.readResponse(res, instream, (long)responseContentLength);
    }

    protected byte[] readResponse(SampleResult res, InputStream instream, long responseContentLength) throws IOException {
        return this.testElement.readResponse(res, instream, responseContentLength);
    }

    @Deprecated
    protected byte[] readResponse(SampleResult res, BufferedInputStream in, int contentLength) throws IOException {
        return this.testElement.readResponse(res, in, contentLength);
    }

    protected byte[] readResponse(SampleResult res, BufferedInputStream in, long contentLength) throws IOException {
        return this.testElement.readResponse(res, in, contentLength);
    }

    protected HTTPSampleResult resultProcessing(boolean areFollowingRedirect, int frameDepth, HTTPSampleResult res) {
        return this.testElement.resultProcessing(areFollowingRedirect, frameDepth, res);
    }

    protected void setUseKeepAlive(boolean b) {
        this.testElement.setUseKeepAlive(b);
    }

    @Deprecated
    protected void notifySSLContextWasReset() {
    }

    protected HTTPSampleResult updateSampleResultForResourceInCache(HTTPSampleResult res) {
        switch (CACHED_RESOURCE_MODE) {
            case RETURN_NO_SAMPLE: {
                return null;
            }
            case RETURN_200_CACHE: {
                res.sampleEnd();
                res.setResponseCodeOK();
                res.setResponseMessage(RETURN_200_CACHE_MESSAGE);
                res.setSuccessful(true);
                return res;
            }
            case RETURN_CUSTOM_STATUS: {
                res.sampleEnd();
                res.setResponseCode(RETURN_CUSTOM_STATUS_CODE);
                res.setResponseMessage(RETURN_CUSTOM_STATUS_MESSAGE);
                res.setSuccessful(true);
                return res;
            }
        }
        throw new IllegalStateException("Unknown CACHED_RESOURCE_MODE: " + (Object)((Object)CACHED_RESOURCE_MODE));
    }

    protected final void configureSampleLabel(SampleResult res, URL url) {
        if (SampleResult.isRenameSampleLabel()) {
            res.setSampleLabel(this.testElement.getName());
        } else {
            res.setSampleLabel(url.toString());
        }
    }

    private static enum CachedResourceMode {
        RETURN_200_CACHE,
        RETURN_NO_SAMPLE,
        RETURN_CUSTOM_STATUS;

    }
}

