/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.pos;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.pos.DodgePos;
import org.jetbrains.letsPlot.core.plot.base.pos.JitterPos;
import org.jetbrains.letsPlot.core.plot.base.pos.PositionAdjustments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/JitterDodgePos;", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "groupCount", "", "width", "", "jitterWidth", "jitterHeight", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;ILjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)V", "myDodgePosHelper", "myJitterPosHelper", "handlesGroups", "", "translate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "plot-base"})
public final class JitterDodgePos
implements PositionAdjustment {
    @NotNull
    private final PositionAdjustment myJitterPosHelper;
    @NotNull
    private final PositionAdjustment myDodgePosHelper;

    public JitterDodgePos(@NotNull Aesthetics aesthetics2, int groupCount, @Nullable Double width2, @Nullable Double jitterWidth, @Nullable Double jitterHeight) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        this.myJitterPosHelper = new JitterPos(jitterWidth, jitterHeight);
        this.myDodgePosHelper = new DodgePos(aesthetics2, groupCount, width2);
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DoubleVector afterJitter = this.myJitterPosHelper.translate(v, p, ctx);
        return this.myDodgePosHelper.translate(afterJitter, p, ctx);
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.JITTER_DODGE.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

