/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.regression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a2\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u001a2\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u001a:\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00010\u0004H\u0002\u001aP\u0010\t\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00010\nj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0001`\u000b2\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u001a&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"allFinite", "Lkotlin/Pair;", "", "xs", "", "", "ys", "averageByX", "lst", "finitePairs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "sumOfDeviationProducts", "xVals", "yVals", "meanX", "meanY", "sumOfSquaredDeviations", "plot-base"})
@SourceDebugExtension(value={"SMAP\nRegressionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1002#3,2:119\n*S KotlinDebug\n*F\n+ 1 RegressionUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionUtilKt\n*L\n113#1:119,2\n*E\n"})
public final class RegressionUtilKt {
    public static final double sumOfSquaredDeviations(@NotNull double[] xVals, double meanX) {
        Intrinsics.checkNotNullParameter((Object)xVals, (String)"xVals");
        return RegressionUtilKt.sumOfDeviationProducts(xVals, xVals, meanX, meanX);
    }

    public static final double sumOfDeviationProducts(@NotNull double[] xVals, @NotNull double[] yVals, double meanX, double meanY) {
        Intrinsics.checkNotNullParameter((Object)xVals, (String)"xVals");
        Intrinsics.checkNotNullParameter((Object)yVals, (String)"yVals");
        Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
        double d = 0.0;
        for (Object t : iterable) {
            Pair pair = (Pair)t;
            double d2 = d;
            boolean bl = false;
            double x = ((Number)pair.component1()).doubleValue();
            double y = ((Number)pair.component2()).doubleValue();
            double d3 = (x - meanX) * (y - meanY);
            d = d2 + d3;
        }
        return d;
    }

    @NotNull
    public static final Pair<double[], double[]> allFinite(@NotNull List<Double> xs, @NotNull List<Double> ys) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        ArrayList<Double> tx = new ArrayList<Double>();
        ArrayList<Double> ty = new ArrayList<Double>();
        for (Pair pair : SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)xs), (Sequence)CollectionsKt.asSequence((Iterable)ys))) {
            Double y;
            Double x = (Double)pair.component1();
            if (!SeriesUtil.INSTANCE.allFinite(x, y = (Double)pair.component2())) continue;
            Double d = x;
            Intrinsics.checkNotNull((Object)d);
            tx.add(d);
            Double d2 = y;
            Intrinsics.checkNotNull((Object)d2);
            ty.add(d2);
        }
        return new Pair((Object)CollectionsKt.toDoubleArray((Collection)tx), (Object)CollectionsKt.toDoubleArray((Collection)ty));
    }

    private static final ArrayList<Pair<Double, Double>> finitePairs(List<Double> xs, List<Double> ys) {
        ArrayList<Pair<Double, Double>> res = new ArrayList<Pair<Double, Double>>();
        for (Pair pair : SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)xs), (Sequence)CollectionsKt.asSequence((Iterable)ys))) {
            Double y;
            Double x = (Double)pair.component1();
            if (!SeriesUtil.INSTANCE.allFinite(x, y = (Double)pair.component2())) continue;
            Double d = x;
            Intrinsics.checkNotNull((Object)d);
            Double d2 = y;
            Intrinsics.checkNotNull((Object)d2);
            res.add((Pair<Double, Double>)new Pair((Object)d, (Object)d2));
        }
        return res;
    }

    private static final Pair<List<Double>, List<Double>> averageByX(List<Pair<Double, Double>> lst) {
        if (lst.isEmpty()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        ArrayList<Double> tx = new ArrayList<Double>();
        ArrayList<Double> ty = new ArrayList<Double>();
        Pair pair = (Pair)CollectionsKt.first(lst);
        double prevX = ((Number)pair.component1()).doubleValue();
        double sumY = ((Number)pair.component2()).doubleValue();
        int countY = 1;
        for (Pair pair2 : SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)lst), (int)1)) {
            double x = ((Number)pair2.component1()).doubleValue();
            double y = ((Number)pair2.component2()).doubleValue();
            if (x == prevX) {
                sumY += y;
                ++countY;
                continue;
            }
            tx.add(prevX);
            ty.add(sumY / (double)countY);
            prevX = x;
            sumY = y;
            countY = 1;
        }
        tx.add(prevX);
        ty.add(sumY / (double)countY);
        return new Pair(tx, ty);
    }

    @NotNull
    public static final Pair<double[], double[]> averageByX(@NotNull List<Double> xs, @NotNull List<Double> ys) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        ArrayList<Pair<Double, Double>> tp = RegressionUtilKt.finitePairs(xs, ys);
        List $this$sortBy$iv = tp;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    Pair it = (Pair)a2;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getFirst()));
                }
            });
        }
        Pair<List<Double>, List<Double>> res = RegressionUtilKt.averageByX((List<Pair<Double, Double>>)tp);
        return new Pair((Object)CollectionsKt.toDoubleArray((Collection)((Collection)res.getFirst())), (Object)CollectionsKt.toDoubleArray((Collection)((Collection)res.getSecond())));
    }
}

