/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.SMIMEAssertion;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;

public class SMIMEAssertionTestElement
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 1L;
    private static final String VERIFY_SIGNATURE_KEY = "SMIMEAssert.verifySignature";
    private static final String NOT_SIGNED_KEY = "SMIMEAssert.notSigned";
    private static final String SIGNER_NO_CHECK_KEY = "SMIMEAssert.signerNoCheck";
    private static final String SIGNER_CHECK_BY_FILE_KEY = "SMIMEAssert.signerCheckByFile";
    private static final String SIGNER_CERT_FILE_KEY = "SMIMEAssert.signerCertFile";
    private static final String SINGER_CHECK_CONSTRAINTS_KEY = "SMIMEAssert.signerCheckConstraints";
    private static final String SIGNER_SERIAL_KEY = "SMIMEAssert.signerSerial";
    private static final String SIGNER_EMAIL_KEY = "SMIMEAssert.signerEmail";
    private static final String SIGNER_DN_KEY = "SMIMEAssert.signerDn";
    private static final String ISSUER_DN_KEY = "SMIMEAssert.issuerDn";
    private static final String MESSAGE_POSITION = "SMIMEAssert.messagePosition";

    public AssertionResult getResult(SampleResult response) {
        try {
            return SMIMEAssertion.getResult(this, response, this.getName());
        }
        catch (NoClassDefFoundError e) {
            AssertionResult assertionResult = new AssertionResult(this.getName());
            assertionResult.setError(true);
            assertionResult.setResultForFailure(JMeterUtils.getResString((String)"bouncy_castle_unavailable_message"));
            return assertionResult;
        }
    }

    public boolean isVerifySignature() {
        return this.getPropertyAsBoolean(VERIFY_SIGNATURE_KEY);
    }

    public void setVerifySignature(boolean verifySignature) {
        this.setProperty(VERIFY_SIGNATURE_KEY, verifySignature);
    }

    public String getIssuerDn() {
        return this.getPropertyAsString(ISSUER_DN_KEY);
    }

    public void setIssuerDn(String issuerDn) {
        this.setProperty(ISSUER_DN_KEY, issuerDn);
    }

    public boolean isSignerCheckByFile() {
        return this.getPropertyAsBoolean(SIGNER_CHECK_BY_FILE_KEY);
    }

    public void setSignerCheckByFile(boolean signerCheckByFile) {
        this.setProperty(SIGNER_CHECK_BY_FILE_KEY, signerCheckByFile);
    }

    public boolean isSignerCheckConstraints() {
        return this.getPropertyAsBoolean(SINGER_CHECK_CONSTRAINTS_KEY);
    }

    public void setSignerCheckConstraints(boolean signerCheckConstraints) {
        this.setProperty(SINGER_CHECK_CONSTRAINTS_KEY, signerCheckConstraints);
    }

    public boolean isSignerNoCheck() {
        return this.getPropertyAsBoolean(SIGNER_NO_CHECK_KEY);
    }

    public void setSignerNoCheck(boolean signerNoCheck) {
        this.setProperty(SIGNER_NO_CHECK_KEY, signerNoCheck);
    }

    public String getSignerCertFile() {
        return this.getPropertyAsString(SIGNER_CERT_FILE_KEY);
    }

    public void setSignerCertFile(String signerCertFile) {
        this.setProperty(SIGNER_CERT_FILE_KEY, signerCertFile);
    }

    public String getSignerDn() {
        return this.getPropertyAsString(SIGNER_DN_KEY);
    }

    public void setSignerDn(String signerDn) {
        this.setProperty(SIGNER_DN_KEY, signerDn);
    }

    public String getSignerSerial() {
        return this.getPropertyAsString(SIGNER_SERIAL_KEY);
    }

    public void setSignerSerial(String signerSerial) {
        this.setProperty(SIGNER_SERIAL_KEY, signerSerial);
    }

    public String getSignerEmail() {
        return this.getPropertyAsString(SIGNER_EMAIL_KEY);
    }

    public void setSignerEmail(String signerEmail) {
        this.setProperty(SIGNER_EMAIL_KEY, signerEmail);
    }

    public boolean isNotSigned() {
        return this.getPropertyAsBoolean(NOT_SIGNED_KEY);
    }

    public void setNotSigned(boolean notSigned) {
        this.setProperty(NOT_SIGNED_KEY, notSigned);
    }

    public String getSpecificMessagePosition() {
        return this.getPropertyAsString(MESSAGE_POSITION);
    }

    public int getSpecificMessagePositionAsInt() {
        return this.getPropertyAsInt(MESSAGE_POSITION, 0);
    }

    public void setSpecificMessagePosition(String position) {
        this.setProperty(MESSAGE_POSITION, position);
    }
}

