/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.StyleContext;
import org.apache.jorphan.gui.DynamicStyle;
import org.apache.jorphan.gui.ui.TextAreaUIWithUndo;
import org.apache.jorphan.gui.ui.TextFieldUIWithUndo;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeterUIDefaults {
    private static final Logger log = LoggerFactory.getLogger(JMeterUIDefaults.class);
    public static final String BUTTON_SMALL_FONT = "[jmeter]Button.smallFont";
    public static final String CHECKBOX_SMALL_FONT = "[jmeter]CheckBox.smallFont";
    public static final String LABEL_SMALL_FONT = "[jmeter]Label.smallFont";
    public static final String TEXTFIELD_SMALL_FONT = "[jmeter]TextField.smallFont";
    public static final String TOOLBAR_SMALL_FONT = "[jmeter]ToolBar.smallFont";
    public static final String LABEL_BIG_FONT = "[jmeter]Label.bigFont";
    public static final String TEXTAREA_BORDER = "[jmeter]TextArea.border";
    public static final String LABEL_WARNING_FONT = "[jmeter]Label.warningFont";
    public static final String LABEL_WARNING_FOREGROUND = "[jmeter]Label.warningForeground";
    public static final String LABEL_ERROR_FONT = "[jmeter]Label.errorFont";
    public static final String LABEL_ERROR_FOREGROUND = "[jmeter]Label.errorForeground";
    public static final String BUTTON_ERROR_FOREGROUND = "[jmeter]Button.errorForeground";
    public static final String TABLE_ROW_HEIGHT = "Table.rowHeight";
    public static final String TREE_ROW_HEIGHT = "Tree.rowHeight";
    private static final float SMALL_FONT_SCALE = 0.8333333f;
    private static final float BIG_FONT_SCALE = 1.3333334f;
    private static final float WARNING_FONT_SCALE = 1.1f;
    private static final float ERROR_FONT_SCALE = 1.1f;
    @API(since="5.3", status=API.Status.INTERNAL)
    public static final JMeterUIDefaults INSTANCE = new JMeterUIDefaults();
    private float scale = 1.0f;

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public float getScale() {
        return this.scale;
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public void setScale(float scale) {
        this.scale = scale;
    }

    private JMeterUIDefaults() {
    }

    @API(since="5.3", status=API.Status.INTERNAL)
    public void install() {
        DynamicStyle.onLaFChange(() -> {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            if (Math.abs(this.scale - 1.0f) > 0.01f) {
                this.scaleFonts(defaults);
                JMeterUIDefaults.scaleIntProperties(defaults, this.scale);
                JMeterUIDefaults.scaleControlsProperties(defaults, (float)Math.sqrt(this.scale));
            }
            JMeterUIDefaults.configureRowHeight(defaults, this.scale, TABLE_ROW_HEIGHT, "Table.font");
            JMeterUIDefaults.configureRowHeight(defaults, this.scale, TREE_ROW_HEIGHT, "Tree.font");
            defaults.put("Button.defaultButtonFollowsFocus", (Object)false);
            defaults.put(TEXTAREA_BORDER, d -> new JTextField().getBorder());
            JMeterUIDefaults.addScaledFont(defaults, BUTTON_SMALL_FONT, "Button.font", 0.8333333f);
            JMeterUIDefaults.addScaledFont(defaults, CHECKBOX_SMALL_FONT, "CheckBox.font", 0.8333333f);
            JMeterUIDefaults.addScaledFont(defaults, LABEL_SMALL_FONT, "Label.font", 0.8333333f);
            JMeterUIDefaults.addScaledFont(defaults, TEXTFIELD_SMALL_FONT, "TextField.font", 0.8333333f);
            JMeterUIDefaults.addScaledFont(defaults, TOOLBAR_SMALL_FONT, "ToolBar.font", 0.8333333f);
            JMeterUIDefaults.addScaledFont(defaults, LABEL_BIG_FONT, "Label.font", 1.3333334f);
            JMeterUIDefaults.addDerivedFont(defaults, LABEL_WARNING_FONT, "Label.font", f -> f.deriveFont(f.getStyle() | 1, f.getSize2D() * 1.1f));
            defaults.put(LABEL_WARNING_FOREGROUND, defaults.get("Label.foreground"));
            JMeterUIDefaults.addDerivedFont(defaults, LABEL_ERROR_FONT, "Label.font", f -> f.deriveFont(f.getStyle() | 1, f.getSize2D() * 1.1f));
            defaults.put(LABEL_ERROR_FOREGROUND, Color.red);
            defaults.put(BUTTON_ERROR_FOREGROUND, Color.red);
            TextFieldUIWithUndo.install(defaults);
            TextAreaUIWithUndo.install(defaults);
        });
    }

    public static Font createFont(String family, int style, int size) {
        return JMeterUIDefaults.stripUiResource(StyleContext.getDefaultStyleContext().getFont(family, style, size));
    }

    private static void addScaledFont(UIDefaults defaults, String output, String input, float scale) {
        JMeterUIDefaults.addDerivedFont(defaults, output, input, f -> f.deriveFont(f.getSize2D() * scale));
    }

    private static void addDerivedFont(UIDefaults defaults, String output, String input, Function<? super Font, ? extends Font> f) {
        defaults.put(output, d -> JMeterUIDefaults.map(d.getFont(input), f));
    }

    private static Font map(Font input, Function<? super Font, ? extends Font> mapper) {
        Font output = mapper.apply(input);
        if (input instanceof UIResource) {
            output = JMeterUIDefaults.stripUiResource(output);
        }
        return output;
    }

    private static void scaleIntProperties(UIDefaults defaults, float scale) {
        JMeterUIDefaults.scaleIntProperty(defaults, "ArrowButton.size", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "ComboBox:\"ComboBox.arrowButton\".size", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "FileChooser.rowHeight", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "Spinner:\"Spinner.codeviousButton\".size", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "Spinner:\"Spinner.nextButton\".size", scale);
    }

    private static void configureRowHeight(UIDefaults defaults, float scale, String rowHeight, String font) {
        if (defaults.getInt(rowHeight) == 0) {
            return;
        }
        defaults.put(rowHeight, d -> {
            float height;
            Font f = d.getFont(font);
            if (f == null) {
                height = 16.0f * scale;
            } else {
                Canvas c = new Canvas();
                height = c.getFontMetrics(f).getHeight();
            }
            int round = (int)Math.floor(height * 1.3f);
            round += round & 1;
            return round;
        });
    }

    private static void scaleControlsProperties(UIDefaults defaults, float scale) {
        JMeterUIDefaults.scaleIntProperty(defaults, "ScrollBar.thumbHeight", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "ScrollBar.width", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "ScrollBar:\"ScrollBar.button\".size", scale);
        JMeterUIDefaults.scaleIntProperty(defaults, "SplitPane.size", scale);
    }

    private static void scaleIntProperty(UIDefaults defaults, String key, float scale) {
        int value = defaults.getInt(key);
        if (value != 0) {
            defaults.put(key, (Object)Math.round((float)value * scale));
        }
    }

    private void scaleFonts(UIDefaults defaults) {
        Font defaultFont;
        log.info("Applying font scale factor: {}", (Object)Float.valueOf(this.scale));
        if ("Nimbus".equals(UIManager.getLookAndFeel().getID()) && (defaultFont = defaults.getFont("defaultFont")) != null) {
            Font newFont = defaultFont.deriveFont(defaultFont.getSize2D() * this.scale);
            defaults.put("defaultFont", JMeterUIDefaults.sameUiResource(defaultFont, newFont));
            return;
        }
        HashMap fonts = new HashMap();
        for (Object k : Collections.list(defaults.keys())) {
            Font font = defaults.getFont(k);
            if (font == null) continue;
            fonts.put(k, font);
        }
        for (Map.Entry entry : fonts.entrySet()) {
            Font oldFont = (Font)entry.getValue();
            Font newFont = JMeterUIDefaults.sameUiResource(oldFont, oldFont.deriveFont(oldFont.getSize2D() * this.scale));
            defaults.put(entry.getKey(), newFont);
        }
    }

    private static Font stripUiResource(Font font) {
        if (font instanceof UIResource) {
            return new NonUIResourceFont(font);
        }
        return font;
    }

    private static Font sameUiResource(Font oldFont, Font newFont) {
        boolean o = oldFont instanceof FontUIResource;
        boolean O = newFont instanceof FontUIResource;
        if (o ^ O) {
            return o ? new FontUIResource(newFont) : JMeterUIDefaults.stripUiResource(newFont);
        }
        return newFont;
    }

    private static class NonUIResourceFont
    extends Font {
        private NonUIResourceFont(Font font) {
            super(font);
        }
    }
}

