/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=0x7FFFFFFF)
@TestElementMetadata(labelResource="displayName")
public class BeanShellPreProcessor
extends BeanShellTestElement
implements Cloneable,
PreProcessor,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BeanShellPreProcessor.class);
    private static final long serialVersionUID = 5L;
    private static final String INIT_FILE = "beanshell.preprocessor.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public void process() {
        block3: {
            BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
            if (bshInterpreter == null) {
                log.error("BeanShell not found");
                return;
            }
            JMeterContext jmctx = JMeterContextService.getContext();
            Sampler sam = jmctx.getCurrentSampler();
            try {
                bshInterpreter.set("sampler", (Object)sam);
                this.processFileOrScript(bshInterpreter);
            }
            catch (JMeterException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("Problem in BeanShell script. {}", (Object)e.toString());
            }
        }
    }

    public Object clone() {
        return super.clone();
    }
}

