/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.util.Objects;

interface ScriptCacheKey {
    public static ScriptCacheKey ofString(String key) {
        return new StringScriptCacheKey(key);
    }

    public static ScriptCacheKey ofFile(String language, String absolutePath, long lastModified) {
        return new FileScriptCacheKey(language, absolutePath, lastModified);
    }

    public static final class StringScriptCacheKey
    implements ScriptCacheKey {
        final String contents;

        StringScriptCacheKey(String contents) {
            this.contents = contents;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringScriptCacheKey that = (StringScriptCacheKey)o;
            return Objects.equals(this.contents, that.contents);
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public String toString() {
            return "StringScriptCacheKey{contents='" + this.contents + '\'' + '}';
        }
    }

    public static final class FileScriptCacheKey
    implements ScriptCacheKey {
        final String language;
        final String absolutePath;
        final long lastModified;

        FileScriptCacheKey(String language, String absolutePath, long lastModified) {
            this.language = language;
            this.absolutePath = absolutePath;
            this.lastModified = lastModified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileScriptCacheKey that = (FileScriptCacheKey)o;
            return Objects.equals(this.language, that.language) && Objects.equals(this.absolutePath, that.absolutePath) && this.lastModified == that.lastModified;
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + this.language.hashCode();
            hash = 31 * hash + this.absolutePath.hashCode();
            hash = 31 * hash + Long.hashCode(this.lastModified);
            return hash;
        }

        public String toString() {
            return "ScriptCacheKey{language='" + this.language + '\'' + ", absolutePath='" + this.absolutePath + '\'' + ", lastModified=" + this.lastModified + '}';
        }
    }
}

