/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.utils.CSSDataURL;
import com.helger.css.utils.CSSDataURLHelper;
import com.helger.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSURI
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sURI;
    private CSSSourceLocation m_aSourceLocation;

    public CSSURI(@Nonnull String string) {
        this.setURI(string);
    }

    @Nonnull
    public final String getURI() {
        return this.m_sURI;
    }

    @Nonnull
    public final CSSURI setURI(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"URI");
        if (CSSURLHelper.isURLValue(string)) {
            throw new IllegalArgumentException("Only the URI and not the CSS-URI value must be passed!");
        }
        this.m_sURI = string;
        return this;
    }

    public boolean isDataURL() {
        return CSSDataURLHelper.isDataURL(this.m_sURI);
    }

    @Nullable
    public CSSDataURL getAsDataURL() {
        return CSSDataURLHelper.parseDataURL(this.m_sURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, iCSSWriterSettings.isQuoteURLs());
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSURI cSSURI = (CSSURI)object;
        return this.m_sURI.equals(cSSURI.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

