/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.io.EAppend;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingFileOutputStream
extends FileOutputStream {
    public static final EAppend DEFAULT_APPEND = EAppend.DEFAULT;
    private static final IMutableStatisticsHandlerSize STATS_WRITE_SIZE = StatisticsManager.getSizeHandler(CountingFileOutputStream.class.getName() + "$write.bytes");
    private static final IMutableStatisticsHandlerCounter STATS_WRITE_FILES = StatisticsManager.getCounterHandler(CountingFileOutputStream.class.getName() + "$write.files");
    private long m_nBytesWritten = 0L;

    public CountingFileOutputStream(@Nonnull File file) throws FileNotFoundException {
        this(file, DEFAULT_APPEND);
    }

    public CountingFileOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) throws FileNotFoundException {
        super(file, eAppend.isAppend());
        STATS_WRITE_FILES.increment();
    }

    public CountingFileOutputStream(@Nonnull String string) throws FileNotFoundException {
        this(string, DEFAULT_APPEND);
    }

    public CountingFileOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) throws FileNotFoundException {
        super(string, eAppend.isAppend());
        STATS_WRITE_FILES.increment();
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        STATS_WRITE_SIZE.addSize(1L);
        ++this.m_nBytesWritten;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
        STATS_WRITE_SIZE.addSize(byArray.length);
        this.m_nBytesWritten += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        STATS_WRITE_SIZE.addSize(n2);
        this.m_nBytesWritten += (long)n2;
    }

    @Nonnegative
    public long getBytesWritten() {
        return this.m_nBytesWritten;
    }

    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("bytesWritten", this.m_nBytesWritten).getToString();
    }
}

