/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.regex;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class RegExPattern {
    private static final AtomicBoolean CHECK_CONSISTENCY_ENABLED = new AtomicBoolean(false);
    private final String m_sRegEx;
    private final int m_nOptions;
    private Pattern m_aPattern;
    private int m_nHashCode = 0;

    public static boolean areDebugConsistencyChecksEnabled() {
        return CHECK_CONSISTENCY_ENABLED.get();
    }

    public static void enableDebugConsistencyChecks(boolean bl) {
        CHECK_CONSISTENCY_ENABLED.set(bl);
    }

    public static void checkPatternConsistency(@Nonnull @RegEx String string) {
        int n = 0;
        while (n >= 0) {
            if ((n = string.indexOf(36, n)) == -1) continue;
            if (!(n == string.length() - 1 || Character.isDigit(string.charAt(n + 1)) || n + 1 < string.length() && string.charAt(n + 1) == ')' || n > 0 && string.charAt(n - 1) == '\\')) {
                throw new IllegalArgumentException("The passed regex '" + string + "' contains an unquoted '$' sign at index " + n + "!");
            }
            ++n;
        }
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String string) {
        this(string, 0);
    }

    public RegExPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        ValueEnforcer.notEmpty(string, "RegEx");
        ValueEnforcer.isGE0(n, "Options");
        this.m_sRegEx = string;
        this.m_nOptions = n;
        if (RegExPattern.areDebugConsistencyChecksEnabled()) {
            RegExPattern.checkPatternConsistency(string);
        }
    }

    @Nonnull
    @RegEx
    @Nonempty
    public String getRegEx() {
        return this.m_sRegEx;
    }

    @Nonnegative
    public int getOptions() {
        return this.m_nOptions;
    }

    @Nonnull
    public Pattern getAsPattern() {
        Pattern pattern = this.m_aPattern;
        if (pattern == null) {
            try {
                this.m_aPattern = pattern = Pattern.compile(this.m_sRegEx, this.m_nOptions);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new IllegalArgumentException("Regular expression '" + this.m_sRegEx + "' is illegal" + (this.m_nOptions == 0 ? "" : " with options " + this.m_nOptions), patternSyntaxException);
            }
        }
        return pattern;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RegExPattern regExPattern = (RegExPattern)object;
        return this.m_sRegEx.equals(regExPattern.m_sRegEx) && this.m_nOptions == regExPattern.m_nOptions;
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sRegEx).append(this.m_nOptions).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regex", this.m_sRegEx).append("options", this.m_nOptions).getToString();
    }
}

