/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.juneau.assertions.AnyAssertion;
import org.apache.juneau.assertions.ArrayAssertion;
import org.apache.juneau.assertions.BeanAssertion;
import org.apache.juneau.assertions.BeanListAssertion;
import org.apache.juneau.assertions.BooleanAssertion;
import org.apache.juneau.assertions.ByteArrayAssertion;
import org.apache.juneau.assertions.CollectionAssertion;
import org.apache.juneau.assertions.ComparableAssertion;
import org.apache.juneau.assertions.DateAssertion;
import org.apache.juneau.assertions.IntegerAssertion;
import org.apache.juneau.assertions.ListAssertion;
import org.apache.juneau.assertions.LongAssertion;
import org.apache.juneau.assertions.MapAssertion;
import org.apache.juneau.assertions.ObjectAssertion;
import org.apache.juneau.assertions.PrimitiveArrayAssertion;
import org.apache.juneau.assertions.StringAssertion;
import org.apache.juneau.assertions.StringListAssertion;
import org.apache.juneau.assertions.ThrowableAssertion;
import org.apache.juneau.assertions.VersionAssertion;
import org.apache.juneau.assertions.ZonedDateTimeAssertion;
import org.apache.juneau.commons.function.Snippet;
import org.apache.juneau.commons.lang.Version;
import org.apache.juneau.commons.utils.IoUtils;

public class Assertions {
    public static final <T> AnyAssertion<T> assertAny(T value) {
        return AnyAssertion.create(value);
    }

    public static final <E> ArrayAssertion<E> assertArray(E[] value) {
        return ArrayAssertion.create(value);
    }

    public static final <T> BeanAssertion<T> assertBean(T value) {
        return BeanAssertion.create(value);
    }

    public static final <E> BeanListAssertion<E> assertBeanList(List<E> value) {
        return BeanListAssertion.create(value);
    }

    public static final BooleanAssertion assertBoolean(Boolean value) {
        return BooleanAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Boolean, boolean[]> assertBooleanArray(boolean[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Byte, byte[]> assertByteArray(byte[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final ByteArrayAssertion assertBytes(byte[] value) {
        return ByteArrayAssertion.create(value);
    }

    public static final ByteArrayAssertion assertBytes(InputStream value) throws IOException {
        return Assertions.assertBytes(value == null ? null : IoUtils.readBytes(value));
    }

    public static final PrimitiveArrayAssertion<Character, char[]> assertCharArray(char[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final <E> CollectionAssertion<E> assertCollection(Collection<E> value) {
        return CollectionAssertion.create(value);
    }

    public static final <T extends Comparable<T>> ComparableAssertion<T> assertComparable(T value) {
        return ComparableAssertion.create(value);
    }

    public static final DateAssertion assertDate(Date value) {
        return DateAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Double, double[]> assertDoubleArray(double[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Float, float[]> assertFloatArray(float[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Integer, int[]> assertIntArray(int[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final IntegerAssertion assertInteger(Integer value) {
        return IntegerAssertion.create(value);
    }

    public static final <E> ListAssertion<E> assertList(List<E> value) {
        return ListAssertion.create(value);
    }

    public static final <E> ListAssertion<E> assertList(Stream<E> value) {
        return ListAssertion.create(value);
    }

    public static final LongAssertion assertLong(Long value) {
        return LongAssertion.create(value);
    }

    public static final PrimitiveArrayAssertion<Long, long[]> assertLongArray(long[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final <K, V> MapAssertion<K, V> assertMap(Map<K, V> value) {
        return MapAssertion.create(value);
    }

    public static final <T> ObjectAssertion<T> assertObject(T value) {
        return ObjectAssertion.create(value);
    }

    public static final <T> AnyAssertion<T> assertOptional(Optional<T> value) {
        return AnyAssertion.create(value.orElse(null));
    }

    public static final StringAssertion assertReader(Reader value) throws IOException {
        return Assertions.assertString(IoUtils.read(value));
    }

    public static final PrimitiveArrayAssertion<Short, short[]> assertShortArray(short[] value) {
        return PrimitiveArrayAssertion.create(value);
    }

    public static final StringAssertion assertString(Object value) {
        if (value instanceof Optional) {
            Optional value2 = (Optional)value;
            value = value2.orElse(null);
        }
        return StringAssertion.create(value);
    }

    public static final StringListAssertion assertStringList(List<String> value) {
        return StringListAssertion.create(value);
    }

    public static final <T extends Throwable> ThrowableAssertion<T> assertThrowable(T value) {
        return ThrowableAssertion.create(value);
    }

    public static final ThrowableAssertion<Throwable> assertThrown(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (Throwable e) {
            return Assertions.assertThrowable(e);
        }
        return Assertions.assertThrowable(null);
    }

    public static final VersionAssertion assertVersion(Version value) {
        return VersionAssertion.create(value);
    }

    public static final ZonedDateTimeAssertion assertZonedDateTime(ZonedDateTime value) {
        return ZonedDateTimeAssertion.create(value);
    }

    protected Assertions() {
    }
}

