/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlTag;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlParserSession;
import org.apache.juneau.xml.XmlReader;
import org.apache.juneau.xml.XmlUtils;

public class HtmlParserSession
extends XmlParserSession {
    private static final Set<String> whitespaceElements = CollectionUtils.set((Object[])new String[]{"br", "bs", "sp", "ff"});
    private final HtmlParser ctx;

    public static Builder create(HtmlParser ctx) {
        return new Builder((HtmlParser)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    private static String getAttribute(XmlReader r, String name, String def) {
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            if (!r.getAttributeLocalName(i).equals(name)) continue;
            return r.getAttributeValue(i);
        }
        return def;
    }

    private static Map<String, String> getAttributes(XmlReader r) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            m.put(r.getAttributeLocalName(i), r.getAttributeValue(i));
        }
        return m;
    }

    private static int skipWs(XmlReader r) throws XMLStreamException {
        int event = r.getEventType();
        while (event != 1 && event != 2 && event != 8 && r.isWhiteSpace()) {
            event = r.next();
        }
        return event;
    }

    protected HtmlParserSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    private HtmlTag nextTag(XmlReader r, HtmlTag ... expected) throws ParseException, XMLStreamException {
        int et = r.next();
        while (et != 1 && et != 2 && et != 8) {
            et = r.next();
        }
        if (et == 8) {
            throw new ParseException((ParserSession)this, "Unexpected end of document.", new Object[0]);
        }
        HtmlTag tag = HtmlTag.forEvent(this, r);
        if (expected.length == 0) {
            return tag;
        }
        for (HtmlTag t : expected) {
            if (t != tag) continue;
            return tag;
        }
        throw new ParseException((ParserSession)this, "Unexpected tag: ''{0}''.  Expected one of the following: {1}", new Object[]{tag, expected});
    }

    private <T> T parseAnchor(XmlReader r, ClassMeta<T> beanType) throws IOException, ParseException, XMLStreamException {
        String href = r.getAttributeValue(null, "href");
        String name = this.getElementText(r);
        if (Utils.nn(beanType) && this.getAnnotationProvider().has(HtmlLink.class, beanType, new AnnotationTraversal[0])) {
            Value uriProperty = Value.empty();
            Value nameProperty = Value.empty();
            beanType.forEachAnnotation(HtmlLink.class, x -> Utils.ne((CharSequence)x.uriProperty()), x -> uriProperty.set((Object)x.uriProperty()));
            beanType.forEachAnnotation(HtmlLink.class, x -> Utils.ne((CharSequence)x.nameProperty()), x -> nameProperty.set((Object)x.nameProperty()));
            BeanMap m = this.newBeanMap(beanType.inner());
            m.put((String)uriProperty.orElse((Object)""), (Object)href);
            m.put((String)nameProperty.orElse((Object)""), (Object)name);
            return m.getBean();
        }
        return this.convertToType((Object)href, beanType);
    }

    private <T> T parseAnything(ClassMeta<T> eType, XmlReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        HtmlTag tag;
        boolean isEmpty;
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<T, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, T> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = Utils.nn(builder) ? builder.getBuilderClassMeta(this) : (Utils.nn(swap) ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)Utils.opt(this.parseAnything(eType.getElementType(), r, outer, isRoot, pMeta));
        }
        this.setCurrentClass(sType);
        int event = r.getEventType();
        if (event != 1) {
            throw new ParseException((ParserSession)this, "parseAnything must be called on outer start element.", new Object[0]);
        }
        if (!isRoot) {
            event = r.next();
        }
        boolean bl = isEmpty = event == 2;
        if (!isEmpty) {
            event = HtmlParserSession.skipWs(r);
        }
        if (event == 8) {
            throw new ParseException((ParserSession)this, "Unexpected end of stream in parseAnything for type ''{0}''", new Object[]{eType});
        }
        HtmlClassMeta hcm = this.getHtmlClassMeta(sType);
        if (hcm.getFormat() == HtmlFormat.XML) {
            return (T)super.parseAnything(eType, null, r, outer, false, pMeta);
        }
        Object o = null;
        boolean isValid = true;
        HtmlTag htmlTag = tag = event == 4 ? null : HtmlTag.forString(r.getName().getLocalPart(), false);
        if (tag == null && event != 4) {
            return (T)super.parseAnything(eType, null, r, outer, false, pMeta);
        }
        if (tag == HtmlTag.HTML) {
            tag = this.skipToData(r);
        }
        if (isEmpty) {
            o = "";
        } else if (tag == null || tag.isOneOf(HtmlTag.BR, HtmlTag.BS, HtmlTag.FF, HtmlTag.SP)) {
            String text = this.parseText(r);
            if (sType.isObject() || sType.isCharSequence()) {
                o = text;
            } else if (sType.isChar()) {
                o = StringUtils.parseCharacter((Object)text);
            } else if (sType.isBoolean()) {
                o = Boolean.parseBoolean(text);
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber((String)text, (Class)eType.inner());
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, text);
            } else {
                isValid = false;
            }
        } else if (tag == HtmlTag.STRING || tag == HtmlTag.A && Utils.nn((Object)pMeta) && Utils.nn((Object)this.getHtmlBeanPropertyMeta(pMeta).getLink())) {
            String text = this.getElementText(r);
            if (sType.isObject() || sType.isCharSequence()) {
                o = text;
            } else if (sType.isChar()) {
                o = StringUtils.parseCharacter((Object)text);
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, text);
            } else {
                isValid = false;
            }
            this.skipTag(r, tag == HtmlTag.STRING ? HtmlTag.xSTRING : HtmlTag.xA);
        } else if (tag == HtmlTag.NUMBER) {
            String text = this.getElementText(r);
            if (sType.isObject()) {
                o = StringUtils.parseNumber((String)text, Number.class);
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber((String)text, (Class)sType.inner());
            } else {
                isValid = false;
            }
            this.skipTag(r, HtmlTag.xNUMBER);
        } else if (tag == HtmlTag.BOOLEAN) {
            String text = this.getElementText(r);
            if (sType.isObject() || sType.isBoolean()) {
                o = Boolean.parseBoolean(text);
            } else {
                isValid = false;
            }
            this.skipTag(r, HtmlTag.xBOOLEAN);
        } else if (tag == HtmlTag.P) {
            String text = this.getElementText(r);
            if (!"No Results".equals(text)) {
                isValid = false;
            }
            this.skipTag(r, HtmlTag.xP);
        } else if (tag == HtmlTag.NULL) {
            this.skipTag(r, HtmlTag.NULL);
            this.skipTag(r, HtmlTag.xNULL);
        } else if (tag == HtmlTag.A) {
            o = this.parseAnchor(r, swap == null ? eType : null);
            this.skipTag(r, HtmlTag.xA);
        } else if (tag == HtmlTag.TABLE) {
            String typeName = HtmlParserSession.getAttribute(r, this.getBeanTypePropertyName(eType), "object");
            ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
            if (Utils.nn(cm)) {
                eType = cm;
                sType = eType;
                typeName = sType.isCollectionOrArray() ? "array" : "object";
            } else if (!"array".equals(typeName)) {
                String string = typeName = sType.isCollectionOrArray() ? "array" : "object";
            }
            if (typeName.equals("object")) {
                if (sType.isObject()) {
                    o = this.parseIntoMap(r, this.newGenericMap(sType), sType.getKeyType(), sType.getValueType(), pMeta);
                } else if (sType.isMap()) {
                    o = this.parseIntoMap(r, (Map)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : this.newGenericMap(sType)), sType.getKeyType(), sType.getValueType(), pMeta);
                } else if (Utils.nn(builder)) {
                    BeanMap<?> m = this.toBeanMap(builder.create(this, eType));
                    o = builder.build(this, this.parseIntoBean(r, m).getBean(), eType);
                } else if (sType.canCreateNewBean(outer)) {
                    BeanMap m = this.newBeanMap(outer, sType.inner());
                    o = this.parseIntoBean(r, m).getBean();
                } else if (Utils.nn((Object)sType.getProxyInvocationHandler())) {
                    BeanMap m = this.newBeanMap(outer, sType.inner());
                    o = this.parseIntoBean(r, m).getBean();
                } else {
                    isValid = false;
                }
                this.skipTag(r, HtmlTag.xTABLE);
            } else if (typeName.equals("array")) {
                if (sType.isObject()) {
                    o = this.parseTableIntoCollection(r, new JsonList(this), sType, pMeta);
                } else if (sType.isCollection()) {
                    o = this.parseTableIntoCollection(r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new JsonList(this)), sType, pMeta);
                } else if (sType.isArray() || sType.isArgs()) {
                    ArrayList l = (ArrayList)this.parseTableIntoCollection(r, CollectionUtils.list((Object[])new Object[0]), sType, pMeta);
                    o = this.toArray(sType, l);
                } else {
                    isValid = false;
                }
                this.skipTag(r, HtmlTag.xTABLE);
            } else {
                isValid = false;
            }
        } else if (tag == HtmlTag.UL) {
            String typeName = HtmlParserSession.getAttribute(r, this.getBeanTypePropertyName(eType), "array");
            ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
            if (Utils.nn(cm)) {
                eType = cm;
                sType = eType;
            }
            if (sType.isObject()) {
                o = this.parseIntoCollection(r, new JsonList(this), sType, pMeta);
            } else if (sType.isCollection() || sType.isObject()) {
                o = this.parseIntoCollection(r, (Collection)(sType.canCreateNewInstance(outer) ? sType.newInstance(outer) : new JsonList(this)), sType, pMeta);
            } else if (sType.isArray() || sType.isArgs()) {
                o = this.toArray(sType, this.parseIntoCollection(r, CollectionUtils.list((Object[])new Object[0]), sType, pMeta));
            } else {
                isValid = false;
            }
            this.skipTag(r, HtmlTag.xUL);
        }
        if (!isValid) {
            throw new ParseException((ParserSession)this, "Unexpected tag ''{0}'' for type ''{1}''", new Object[]{tag, eType});
        }
        if (Utils.nn(swap) && Utils.nn((Object)o)) {
            o = this.unswap(swap, o, eType);
        }
        if (Utils.nn((Object)outer)) {
            HtmlParserSession.setParent(eType, o, outer);
        }
        HtmlParserSession.skipWs(r);
        return (T)o;
    }

    private <T> BeanMap<T> parseIntoBean(XmlReader r, BeanMap<T> m) throws IOException, ParseException, ExecutableException, XMLStreamException {
        HtmlTag tag;
        while ((tag = this.nextTag(r, HtmlTag.TR, HtmlTag.xTABLE)) != HtmlTag.xTABLE) {
            HtmlTag t;
            tag = this.nextTag(r, HtmlTag.TD, HtmlTag.TH);
            if (tag == HtmlTag.TH) {
                this.skipTag(r);
                r.nextTag();
                this.skipTag(r);
            } else {
                String key = this.getElementText(r);
                this.nextTag(r, HtmlTag.TD);
                BeanPropertyMeta pMeta = m.getPropertyMeta(key);
                if (pMeta == null) {
                    this.onUnknownProperty(key, m, this.parseAnything(this.object(), r, null, false, null));
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    Object value = this.parseAnything(cm, r, m.getBean(false), false, pMeta);
                    HtmlParserSession.setName(cm, value, key);
                    try {
                        pMeta.set(m, key, value);
                    }
                    catch (BeanRuntimeException e) {
                        this.onBeanSetterException(pMeta, e);
                        throw e;
                    }
                }
            }
            if ((t = this.nextTag(r, HtmlTag.xTD, HtmlTag.xTR)) != HtmlTag.xTD) continue;
            this.nextTag(r, HtmlTag.xTR);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(XmlReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        int argIndex = 0;
        while (true) {
            HtmlTag tag;
            if ((tag = this.nextTag(r, HtmlTag.LI, HtmlTag.xUL, HtmlTag.xLI)) == HtmlTag.xLI) {
                tag = this.nextTag(r, HtmlTag.LI, HtmlTag.xUL, HtmlTag.xLI);
            }
            if (tag == HtmlTag.xUL) break;
            ClassMeta<?> elementType = type.isArgs() ? type.getArg(argIndex++) : type.getElementType();
            l.add(this.parseAnything(elementType, r, l, false, pMeta));
        }
        return l;
    }

    private <K, V> Map<K, V> parseIntoMap(XmlReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        HtmlTag tag;
        while ((tag = this.nextTag(r, HtmlTag.TR, HtmlTag.xTABLE)) != HtmlTag.xTABLE) {
            tag = this.nextTag(r, HtmlTag.TD, HtmlTag.TH);
            if (tag == HtmlTag.TH) {
                this.skipTag(r);
                r.nextTag();
                this.skipTag(r);
            } else {
                K key = this.parseAnything(keyType, r, m, false, pMeta);
                this.nextTag(r, HtmlTag.TD);
                V value = this.parseAnything(valueType, r, m, false, pMeta);
                HtmlParserSession.setName(valueType, value, key);
                m.put(key, value);
            }
            if ((tag = this.nextTag(r, HtmlTag.xTD, HtmlTag.xTR)) != HtmlTag.xTD) continue;
            this.nextTag(r, HtmlTag.xTR);
        }
        return m;
    }

    private <E> Collection<E> parseTableIntoCollection(XmlReader r, Collection<E> l, ClassMeta<E> type, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException, XMLStreamException {
        HtmlTag tag = this.nextTag(r, HtmlTag.TR);
        List keys = CollectionUtils.list((Object[])new String[0]);
        while ((tag = this.nextTag(r, HtmlTag.TH, HtmlTag.xTR)) != HtmlTag.xTR) {
            keys.add(this.getElementText(r));
        }
        int argIndex = 0;
        while (true) {
            BuilderSwap<Object, Object> builder;
            r.nextTag();
            tag = HtmlTag.forEvent(this, r);
            if (tag == HtmlTag.xTABLE) break;
            ClassMeta<Object> elementType = null;
            String beanType = HtmlParserSession.getAttribute(r, this.getBeanTypePropertyName(type), null);
            if (Utils.nn((Object)beanType)) {
                elementType = this.getClassMeta(beanType, pMeta, null);
            }
            if (elementType == null) {
                ClassMeta<Object> classMeta = elementType = type.isArgs() ? type.getArg(argIndex++) : type.getElementType();
            }
            if (elementType == null) {
                elementType = this.object();
            }
            if (Utils.nn(builder = elementType.getBuilderSwap(this)) || elementType.canCreateNewBean(l)) {
                BeanMap<Object> m = Utils.nn(builder) ? this.toBeanMap(builder.create(this, elementType)) : this.newBeanMap(l, elementType.inner());
                for (Object key : keys) {
                    tag = this.nextTag(r, HtmlTag.xTD, HtmlTag.TD, HtmlTag.NULL);
                    if (tag == HtmlTag.xTD) {
                        tag = this.nextTag(r, HtmlTag.TD, HtmlTag.NULL);
                    }
                    if (tag == HtmlTag.NULL) {
                        m = null;
                        this.nextTag(r, HtmlTag.xNULL);
                        break;
                    }
                    BeanMapEntry e = m.getProperty((String)key);
                    if (e == null) {
                        this.parseAnything(this.object(), r, l, false, null);
                        continue;
                    }
                    BeanPropertyMeta bpm = e.getMeta();
                    ClassMeta<?> cm = bpm.getClassMeta();
                    value = this.parseAnything(cm, r, m.getBean(false), false, bpm);
                    HtmlParserSession.setName(cm, value, key);
                    bpm.set(m, (String)key, value);
                }
                l.add(m == null ? null : (Utils.nn(builder) ? builder.build(this, m.getBean(), elementType) : m.getBean()));
            } else {
                Object key;
                String c = HtmlParserSession.getAttributes(r).get(this.getBeanTypePropertyName(type.getElementType()));
                Map m = elementType.isMap() && elementType.canCreateNewInstance(l) ? elementType.newInstance(l) : this.newGenericMap(elementType);
                key = keys.iterator();
                while (key.hasNext()) {
                    String key2 = (String)key.next();
                    tag = this.nextTag(r, HtmlTag.TD, HtmlTag.NULL);
                    if (tag == HtmlTag.NULL) {
                        m = null;
                        this.nextTag(r, HtmlTag.xNULL);
                        break;
                    }
                    if (!Utils.nn((Object)m)) continue;
                    ClassMeta<?> kt = elementType.getKeyType();
                    ClassMeta<?> vt = elementType.getValueType();
                    value = this.parseAnything(vt, r, l, false, pMeta);
                    HtmlParserSession.setName(vt, value, key2);
                    m.put(this.convertToType((Object)key2, kt), value);
                }
                if (Utils.nn((Object)m) && Utils.nn((Object)c)) {
                    m2 = m instanceof JsonMap ? (JsonMap)m : new JsonMap((Map<?, ?>)m).session(this);
                    m2.put(this.getBeanTypePropertyName(type.getElementType()), (Object)c);
                    l.add(this.cast(m2, pMeta, elementType));
                } else if (m instanceof JsonMap) {
                    m2 = (JsonMap)m;
                    l.add(this.convertToType((Object)m2, elementType));
                } else {
                    l.add(m);
                }
            }
            this.nextTag(r, HtmlTag.xTR);
        }
        return l;
    }

    private void skipTag(XmlReader r) throws ParseException, XMLStreamException {
        int et = r.getEventType();
        if (et != 1) {
            throw new ParseException((ParserSession)this, "skipToNextTag() call on invalid event ''{0}''.  Must only be called on START_ELEMENT events.", XmlUtils.toReadableEvent(r));
        }
        String n = r.getLocalName();
        int depth = 0;
        while (true) {
            String n2;
            if ((et = r.next()) == 1) {
                n2 = r.getLocalName();
                if (!n.equals(n2)) continue;
                ++depth;
                continue;
            }
            if (et != 2) continue;
            n2 = r.getLocalName();
            if (n.equals(n2)) {
                --depth;
            }
            if (depth < 0) break;
        }
    }

    private void skipTag(XmlReader r, HtmlTag ... expected) throws ParseException, XMLStreamException {
        HtmlTag tag = HtmlTag.forEvent(this, r);
        if (!tag.isOneOf(expected)) {
            throw new ParseException((ParserSession)this, "Unexpected tag: ''{0}''.  Expected one of the following: {1}", new Object[]{tag, expected});
        }
        r.next();
    }

    private HtmlTag skipToData(XmlReader r) throws ParseException, XMLStreamException {
        boolean isEmpty;
        int event;
        while ((event = r.next()) != 1 || !"div".equals(r.getLocalName()) || !"data".equals(r.getAttributeValue(null, "id"))) {
        }
        r.nextTag();
        event = r.getEventType();
        boolean bl = isEmpty = event == 2;
        if (!isEmpty) {
            event = HtmlParserSession.skipWs(r);
        }
        if (event == 8) {
            throw new ParseException((ParserSession)this, "Unexpected end of stream looking for data.", new Object[0]);
        }
        return event == 4 ? null : HtmlTag.forString(r.getName().getLocalPart(), false);
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try {
            return this.parseAnything(type, this.getXmlReader(pipe), this.getOuter(), true, null);
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        return this.parseIntoCollection(this.getXmlReader(pipe), c, this.getClassMeta(elementType, new Type[0]), null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        return this.parseIntoMap(this.getXmlReader(pipe), m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
    }

    @Override
    protected String getElementText(XmlReader r) throws IOException, XMLStreamException, ParseException {
        r.next();
        return this.parseText(r);
    }

    protected HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getHtmlBeanPropertyMeta(bpm);
    }

    protected HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        return this.ctx.getHtmlClassMeta(cm);
    }

    @Override
    protected boolean isWhitespaceElement(XmlReader r) {
        String s = r.getLocalName();
        return whitespaceElements.contains(s);
    }

    @Override
    protected String parseText(XmlReader r) throws IOException, ParseException, XMLStreamException {
        StringBuilder sb = this.getStringBuilder();
        int et = r.getEventType();
        if (et == 2) {
            return "";
        }
        int depth = 0;
        String characters = null;
        while (true) {
            if (et == 1) {
                HtmlTag tag;
                if (Utils.nn((Object)characters)) {
                    if (sb.length() == 0) {
                        characters = StringUtils.trimStart((String)characters);
                    }
                    sb.append(characters);
                    characters = null;
                }
                if ((tag = HtmlTag.forEvent(this, r)) == HtmlTag.BR) {
                    sb.append('\n');
                    r.nextTag();
                } else if (tag == HtmlTag.BS) {
                    sb.append('\b');
                    r.nextTag();
                } else if (tag == HtmlTag.SP) {
                    et = r.next();
                    if (et == 4) {
                        String s = r.getText();
                        if (Utils.ne((CharSequence)s)) {
                            char c = r.getText().charAt(0);
                            if (c == '\u2003') {
                                c = '\t';
                            }
                            sb.append(c);
                        }
                        r.nextTag();
                    }
                } else if (tag == HtmlTag.FF) {
                    sb.append('\f');
                    r.nextTag();
                } else if (tag.isOneOf(HtmlTag.STRING, HtmlTag.NUMBER, HtmlTag.BOOLEAN)) {
                    et = r.next();
                    if (et == 4) {
                        sb.append(r.getText());
                        r.nextTag();
                    }
                } else {
                    sb.append('<').append(r.getLocalName());
                    for (int i = 0; i < r.getAttributeCount(); ++i) {
                        sb.append(' ').append(r.getAttributeName(i)).append('=').append('\'').append(r.getAttributeValue(i)).append('\'');
                    }
                    sb.append('>');
                    ++depth;
                }
            } else if (et == 2) {
                if (Utils.nn((Object)characters)) {
                    if (sb.length() == 0) {
                        characters = StringUtils.trimStart((String)characters);
                    }
                    if (depth == 0) {
                        characters = StringUtils.trimEnd((String)characters);
                    }
                    sb.append(characters);
                    characters = null;
                }
                if (depth == 0) break;
                sb.append('<').append(r.getLocalName()).append('>');
                --depth;
            } else if (et == 4) {
                characters = r.getText();
            }
            et = r.next();
        }
        String s = this.trim(sb.toString());
        this.returnStringBuilder(sb);
        return s;
    }

    @Override
    protected String parseWhitespaceElement(XmlReader r) throws IOException, ParseException, XMLStreamException {
        HtmlTag tag = HtmlTag.forEvent(this, r);
        int et = r.next();
        if (tag == HtmlTag.BR) {
            return "\n";
        }
        if (tag == HtmlTag.BS) {
            return "\b";
        }
        if (tag == HtmlTag.FF) {
            return "\f";
        }
        if (tag == HtmlTag.SP) {
            if (et == 4) {
                String s = r.getText();
                if (s.charAt(0) == '\u2003') {
                    s = "\t";
                }
                r.next();
                return this.decodeString(s);
            }
            return "";
        }
        throw new ParseException((ParserSession)this, "Invalid tag found in parseWhitespaceElement(): ''{0}''", new Object[]{tag});
    }

    public static class Builder
    extends XmlParserSession.Builder {
        private HtmlParser ctx;

        protected Builder(HtmlParser ctx) {
            super((XmlParser)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public HtmlParserSession build() {
            return new HtmlParserSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

