/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.httppart.HttpPartSchema;

public class HeaderBeanMeta<T> {
    private static final ConcurrentHashMap<Class<?>, HeaderBeanMeta<?>> CACHE = new ConcurrentHashMap();
    private final Class<T> type;
    private final Constructor<T> constructor;
    private final HttpPartSchema schema;

    public static <T> HeaderBeanMeta<T> of(Class<T> type) {
        HeaderBeanMeta<Object> m = CACHE.get(type);
        if (m == null) {
            m = new HeaderBeanMeta<T>(type);
            CACHE.put(type, m);
        }
        return m;
    }

    private HeaderBeanMeta(Class<T> type) {
        this.type = type;
        ClassInfoTyped ci = ClassInfo.of(type);
        this.constructor = ci.getPublicConstructor(x -> x.hasParameterTypes(new Class[]{String.class})).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(new Class[]{Object.class}))).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(new Class[]{String.class, String.class}))).or(() -> ci.getPublicConstructor(x -> x.hasParameterTypes(new Class[]{String.class, Object.class}))).map(x -> x.inner()).orElse(null);
        this.schema = HttpPartSchema.create(Header.class, type);
    }

    public T construct(Object value) {
        return this.construct(null, value);
    }

    public T construct(String name, Object value) {
        if (this.constructor == null) {
            throw ThrowableUtils.unsupportedOp((String)"Constructor for type {0} could not be found.", (Object[])new Object[]{Utils.cn(this.type)});
        }
        if (name == null) {
            name = this.schema.getName();
        }
        Class<?>[] pt = this.constructor.getParameterTypes();
        Object[] args = new Object[pt.length];
        if (pt.length == 1) {
            args[0] = pt[0] == String.class ? Utils.s((Object)value) : value;
        } else {
            if (name == null) {
                throw ThrowableUtils.unsupportedOp((String)"Constructor for type {0} requires a name as the first argument.", (Object[])new Object[]{Utils.cn(this.type)});
            }
            args[0] = name;
            args[1] = pt[1] == String.class ? Utils.s((Object)value) : value;
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }
}

