/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.internals.assignment.ConsumerProtocolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskId
implements Comparable<TaskId> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskId.class);
    public static final String NAMED_TOPOLOGY_DELIMITER = "__";
    @Deprecated
    public final int topicGroupId;
    @Deprecated
    public final int partition;
    private final String topologyName;

    public TaskId(int topicGroupId, int partition) {
        this(topicGroupId, partition, null);
    }

    public TaskId(int topicGroupId, int partition, String topologyName) {
        this.topicGroupId = topicGroupId;
        this.partition = partition;
        if (topologyName != null && topologyName.length() == 0) {
            LOG.warn("Empty string passed in for task's namedTopology, since NamedTopology name cannot be empty, we assume this task does not belong to a NamedTopology and downgrade this to null");
            this.topologyName = null;
        } else {
            this.topologyName = topologyName;
        }
    }

    public int subtopology() {
        return this.topicGroupId;
    }

    public int partition() {
        return this.partition;
    }

    public String topologyName() {
        return this.topologyName;
    }

    public String toString() {
        return this.topologyName != null ? this.topologyName + NAMED_TOPOLOGY_DELIMITER + this.topicGroupId + "_" + this.partition : this.topicGroupId + "_" + this.partition;
    }

    public static TaskId parse(String taskIdStr) {
        try {
            int namedTopologyDelimiterIndex = taskIdStr.indexOf(NAMED_TOPOLOGY_DELIMITER);
            if (namedTopologyDelimiterIndex < 0) {
                int index = taskIdStr.indexOf(95);
                int topicGroupId = Integer.parseInt(taskIdStr.substring(0, index));
                int partition = Integer.parseInt(taskIdStr.substring(index + 1));
                return new TaskId(topicGroupId, partition);
            }
            int topicGroupIdIndex = namedTopologyDelimiterIndex + 2;
            int subtopologyPartitionDelimiterIndex = taskIdStr.indexOf(95, topicGroupIdIndex);
            String namedTopology = taskIdStr.substring(0, namedTopologyDelimiterIndex);
            int topicGroupId = Integer.parseInt(taskIdStr.substring(topicGroupIdIndex, subtopologyPartitionDelimiterIndex));
            int partition = Integer.parseInt(taskIdStr.substring(subtopologyPartitionDelimiterIndex + 1));
            return new TaskId(topicGroupId, partition, namedTopology);
        }
        catch (Exception e) {
            throw new TaskIdFormatException(taskIdStr);
        }
    }

    @Deprecated
    public void writeTo(DataOutputStream out, int version) throws IOException {
        ConsumerProtocolUtils.writeTaskIdTo(this, out, version);
    }

    @Deprecated
    public static TaskId readFrom(DataInputStream in, int version) throws IOException {
        return ConsumerProtocolUtils.readTaskIdFrom(in, version);
    }

    @Deprecated
    public void writeTo(ByteBuffer buf, int version) {
        ConsumerProtocolUtils.writeTaskIdTo(this, buf, version);
    }

    @Deprecated
    public static TaskId readFrom(ByteBuffer buf, int version) {
        return ConsumerProtocolUtils.readTaskIdFrom(buf, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        if (this.topicGroupId != taskId.topicGroupId || this.partition != taskId.partition) {
            return false;
        }
        if (this.topologyName != null && taskId.topologyName != null) {
            return this.topologyName.equals(taskId.topologyName);
        }
        return this.topologyName == null && taskId.topologyName == null;
    }

    public int hashCode() {
        return Objects.hash(this.topicGroupId, this.partition, this.topologyName);
    }

    @Override
    public int compareTo(TaskId other) {
        int comparingTopicGroupId;
        if (this.topologyName != null && other.topologyName != null) {
            int comparingNamedTopologies = this.topologyName.compareTo(other.topologyName);
            if (comparingNamedTopologies != 0) {
                return comparingNamedTopologies;
            }
        } else if (this.topologyName != null || other.topologyName != null) {
            LOG.error("Tried to compare this = {} with other = {}, but only one had a valid named topology", (Object)this, (Object)other);
            throw new IllegalStateException("Can't compare a TaskId with a namedTopology to one without");
        }
        return (comparingTopicGroupId = Integer.compare(this.topicGroupId, other.topicGroupId)) != 0 ? comparingTopicGroupId : Integer.compare(this.partition, other.partition);
    }
}

