/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.processor.TaskId;

public class TaskMetadataImpl
implements TaskMetadata {
    private final TaskId taskId;
    private final Set<TopicPartition> topicPartitions;
    private final Map<TopicPartition, Long> committedOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private final Optional<Long> timeCurrentIdlingStarted;

    public TaskMetadataImpl(TaskId taskId, Set<TopicPartition> topicPartitions, Map<TopicPartition, Long> committedOffsets, Map<TopicPartition, Long> endOffsets, Optional<Long> timeCurrentIdlingStarted) {
        this.taskId = taskId;
        this.topicPartitions = Collections.unmodifiableSet(topicPartitions);
        this.committedOffsets = Collections.unmodifiableMap(committedOffsets);
        this.endOffsets = Collections.unmodifiableMap(endOffsets);
        this.timeCurrentIdlingStarted = timeCurrentIdlingStarted;
    }

    @Override
    public TaskId taskId() {
        return this.taskId;
    }

    @Override
    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Override
    public Map<TopicPartition, Long> committedOffsets() {
        return this.committedOffsets;
    }

    @Override
    public Map<TopicPartition, Long> endOffsets() {
        return this.endOffsets;
    }

    @Override
    public Optional<Long> timeCurrentIdlingStarted() {
        return this.timeCurrentIdlingStarted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskMetadataImpl that = (TaskMetadataImpl)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.topicPartitions, that.topicPartitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.taskId, this.topicPartitions);
    }

    public String toString() {
        return "TaskMetadata{taskId=" + this.taskId + ", topicPartitions=" + this.topicPartitions + ", committedOffsets=" + this.committedOffsets + ", endOffsets=" + this.endOffsets + ", timeCurrentIdlingStarted=" + this.timeCurrentIdlingStarted + '}';
    }
}

