/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsUtils;

public class MetadataQuorumCommand {
    public static void main(String ... args) {
        Exit.exit((int)MetadataQuorumCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            MetadataQuorumCommand.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        block9: {
            ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-quorum").defaultHelp(true).description("This tool describes kraft metadata quorum status.");
            MutuallyExclusiveGroup connectionOptions = parser.addMutuallyExclusiveGroup().required(true);
            connectionOptions.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.");
            connectionOptions.addArgument(new String[]{"--bootstrap-controller"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka controllers.");
            parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client.");
            MetadataQuorumCommand.addDescribeSubParser(parser);
            try (Admin admin = null;){
                Namespace namespace = parser.parseArgsOrFail(args);
                String command = namespace.getString("command");
                File optionalCommandConfig = (File)namespace.get("command_config");
                Properties props = MetadataQuorumCommand.getProperties(optionalCommandConfig);
                CommandLineUtils.initializeBootstrapProperties((Properties)props, Optional.ofNullable(namespace.getString("bootstrap_server")), Optional.ofNullable(namespace.getString("bootstrap_controller")));
                admin = Admin.create((Properties)props);
                if (command.equals("describe")) {
                    if (namespace.getBoolean("status").booleanValue() && namespace.getBoolean("replication").booleanValue()) {
                        throw new TerseException("Only one of --status or --replication should be specified with describe sub-command");
                    }
                    if (namespace.getBoolean("replication").booleanValue()) {
                        boolean humanReadable = Optional.of(namespace.getBoolean("human_readable")).orElse(false);
                        MetadataQuorumCommand.handleDescribeReplication(admin, humanReadable);
                        break block9;
                    }
                    if (namespace.getBoolean("status").booleanValue()) {
                        if (namespace.getBoolean("human_readable").booleanValue()) {
                            throw new TerseException("The option --human-readable is only supported along with --replication");
                        }
                        MetadataQuorumCommand.handleDescribeStatus(admin);
                        break block9;
                    }
                    throw new TerseException("One of --status or --replication must be specified with describe sub-command");
                }
                throw new IllegalStateException(String.format("Unknown command: %s, only 'describe' is supported", command));
            }
        }
    }

    private static Properties getProperties(File optionalCommandConfig) throws TerseException, IOException {
        if (optionalCommandConfig == null) {
            return new Properties();
        }
        if (!optionalCommandConfig.exists()) {
            throw new TerseException("Properties file " + optionalCommandConfig.getPath() + " does not exists!");
        }
        return Utils.loadProps((String)optionalCommandConfig.getPath());
    }

    private static void addDescribeSubParser(ArgumentParser parser) {
        Subparsers subparsers = parser.addSubparsers().dest("command");
        Subparser describeParser = subparsers.addParser("describe").help("Describe the metadata quorum info");
        ArgumentGroup statusArgs = describeParser.addArgumentGroup("Status");
        statusArgs.addArgument(new String[]{"--status"}).help("A short summary of the quorum status and the other provides detailed information about the status of replication.").action((ArgumentAction)Arguments.storeTrue());
        ArgumentGroup replicationArgs = describeParser.addArgumentGroup("Replication");
        replicationArgs.addArgument(new String[]{"--replication"}).help("Detailed information about the status of replication").action((ArgumentAction)Arguments.storeTrue());
        replicationArgs.addArgument(new String[]{"--human-readable"}).help("Human-readable output").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void handleDescribeReplication(Admin admin, boolean humanReadable) throws ExecutionException, InterruptedException {
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, Stream.of(leader), "Leader", humanReadable));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.voters().stream().filter(v -> v.replicaId() != leaderId), "Follower", humanReadable));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.observers().stream(), "Observer", humanReadable));
        ToolsUtils.prettyPrintTable(Arrays.asList("NodeId", "LogEndOffset", "Lag", "LastFetchTimestamp", "LastCaughtUpTimestamp", "Status"), rows, System.out);
    }

    private static List<List<String>> quorumInfoToRows(QuorumInfo.ReplicaState leader, Stream<QuorumInfo.ReplicaState> infos, String status, boolean humanReadable) {
        return infos.map(info -> {
            String lastFetchTimestamp;
            String string = !info.lastFetchTimestamp().isPresent() ? "-1" : (lastFetchTimestamp = humanReadable ? String.format("%d ms ago", MetadataQuorumCommand.relativeTimeMs(info.lastFetchTimestamp().getAsLong(), "last fetch")) : String.valueOf(info.lastFetchTimestamp().getAsLong()));
            String lastCaughtUpTimestamp = !info.lastCaughtUpTimestamp().isPresent() ? "-1" : (humanReadable ? String.format("%d ms ago", MetadataQuorumCommand.relativeTimeMs(info.lastCaughtUpTimestamp().getAsLong(), "last caught up")) : String.valueOf(info.lastCaughtUpTimestamp().getAsLong()));
            return Stream.of(Integer.valueOf(info.replicaId()), info.logEndOffset(), leader.logEndOffset() - info.logEndOffset(), lastFetchTimestamp, lastCaughtUpTimestamp, status).map(r -> r.toString()).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    static long relativeTimeMs(long timestampMs, String desc) {
        Instant lastTimestamp = Instant.ofEpochMilli(timestampMs);
        Instant now = Instant.now();
        if (!lastTimestamp.isAfter(Instant.EPOCH) || !lastTimestamp.isBefore(now) && !lastTimestamp.equals(now)) {
            throw new KafkaException(String.format("Error while computing relative time, possible drift in system clock.%nCurrent timestamp is %d, %s timestamp is %d", now.toEpochMilli(), desc, timestampMs));
        }
        return Duration.between(lastTimestamp, now).toMillis();
    }

    private static void handleDescribeStatus(Admin admin) throws ExecutionException, InterruptedException {
        String clusterId = (String)admin.describeCluster().clusterId().get();
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        QuorumInfo.ReplicaState maxLagFollower = quorumInfo.voters().stream().min(Comparator.comparingLong(qi -> qi.logEndOffset())).get();
        long maxFollowerLag = leader.logEndOffset() - maxLagFollower.logEndOffset();
        long maxFollowerLagTimeMs = leader == maxLagFollower ? 0L : (leader.lastCaughtUpTimestamp().isPresent() && maxLagFollower.lastCaughtUpTimestamp().isPresent() ? leader.lastCaughtUpTimestamp().getAsLong() - maxLagFollower.lastCaughtUpTimestamp().getAsLong() : -1L);
        System.out.println("ClusterId:              " + clusterId + "\nLeaderId:               " + quorumInfo.leaderId() + "\nLeaderEpoch:            " + quorumInfo.leaderEpoch() + "\nHighWatermark:          " + quorumInfo.highWatermark() + "\nMaxFollowerLag:         " + maxFollowerLag + "\nMaxFollowerLagTimeMs:   " + maxFollowerLagTimeMs + "\nCurrentVoters:          " + quorumInfo.voters().stream().map(QuorumInfo.ReplicaState::replicaId).map(Object::toString).collect(Collectors.joining(",", "[", "]")) + "\nCurrentObservers:       " + quorumInfo.observers().stream().map(QuorumInfo.ReplicaState::replicaId).map(Objects::toString).collect(Collectors.joining(",", "[", "]")));
    }
}

