/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005cA\u00021b\u0003\u0003\u0019W\r\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001z\u0011!q\bA!A!\u0002\u0013Q\b\"C@\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\ty\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003#\u0001!\u00111A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\t\u0005\r\u0011\"\u0001\u0002$!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006K!!\u0006\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003K\u0002!\u0011!Q\u0001\n\u0005\u001d\u0004BCA7\u0001\t\u0005\t\u0015!\u0003\u0002p!Q\u0011Q\u000f\u0001\u0003\u0002\u0003\u0006I!a\u001e\t\u0015\u0005\u0005\u0005A!A!\u0002\u0013\t\u0019\t\u0003\u0006\u0002\u0010\u0002\u0011\t\u0011)A\u0005\u0003#C!\"a&\u0001\u0005\u0003\u0005\u000b\u0011BAM\u0011)\t)\u000b\u0001B\u0001B\u0003%\u0011q\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011%\ti\r\u0001b\u0001\n\u0013\ty\r\u0003\u0005\u0002^\u0002\u0001\u000b\u0011BAi\u0011%\ty\u000e\u0001b\u0001\n\u0003\t\t\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAr\u0011\u001d\tI\u0010\u0001D\u0001\u0003wDqAa\u0005\u0001\r\u0003\tY\u0010C\u0005\u0003\u0016\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!q\u0004\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003\"\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!1\u0005\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003&\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!q\u0005\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,!A!Q\b\u0001!\u0002\u0013\u0011i\u0003\u0003\u0007\u0003@\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0014\t\u0005\u0003\u0007\u0003J\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0014Y\u0005C\u0006\u0003P\u0001\u0001\r\u0011!Q!\n\t\r\u0003B\u0003B)\u0001\t\u0007I\u0011A1\u0003T!A!Q\u000b\u0001!\u0002\u0013\tI\u0004\u0003\u0006\u0003X\u0001\u0011\r\u0011\"\u0001b\u00053B\u0001B!\u001d\u0001A\u0003%!1\f\u0005\n\u0005g\u0002!\u0019!C\u0005\u0005kB\u0001B!$\u0001A\u0003%!q\u000f\u0005\n\u0005\u001f\u0003!\u0019!C\u0005\u0005#C\u0001B!'\u0001A\u0003%!1\u0013\u0005\n\u00057\u0003\u0001\u0019!C\u0005\u0005'B\u0011B!(\u0001\u0001\u0004%IAa(\t\u0011\t\r\u0006\u0001)Q\u0005\u0003sA!B!*\u0001\u0005\u0004%\t!\u0019BT\u0011!\u0019\u0019\u0007\u0001Q\u0001\n\t%\u0006\"CB3\u0001\t\u0007I\u0011BAq\u0011!\u00199\u0007\u0001Q\u0001\n\u0005\r\bBCB5\u0001\t\u0007I\u0011A1\u0004l!A11\u0010\u0001!\u0002\u0013\u0019i\u0007C\u0005\u0004~\u0001\u0011\r\u0011\"\u0001\u0004\u0000!A1q\u0011\u0001!\u0002\u0013\u0019\t\tC\u0004\u0004\n\u0002!\taa#\u0007\u000f\tM\u0006\u0001Q1\u00036\"Q!1\\\u001d\u0003\u0016\u0004%\tA!8\t\u0015\t\u0015\u0018H!E!\u0002\u0013\u0011y\u000e\u0003\u0006\u0003hf\u0012)\u001a!C\u0001\u0005SD!B!=:\u0005#\u0005\u000b\u0011\u0002Bv\u0011\u001d\ti+\u000fC\u0001\u0005gDqA!?:\t\u0003\u0012Y\u0010C\u0005\u0004\u0002e\n\t\u0011\"\u0001\u0004\u0004!I1\u0011B\u001d\u0012\u0002\u0013\u000511\u0002\u0005\n\u0007CI\u0014\u0013!C\u0001\u0007GA\u0011ba\n:\u0003\u0003%\te!\u000b\t\u0013\r=\u0012(!A\u0005\u0002\tM\u0003\"CB\u0019s\u0005\u0005I\u0011AB\u001a\u0011%\u0019i$OA\u0001\n\u0003\u001ay\u0004C\u0005\u0004Je\n\t\u0011\"\u0001\u0004L!I1qJ\u001d\u0002\u0002\u0013\u00053\u0011\u000b\u0005\n\u0007+J\u0014\u0011!C!\u0007/B\u0011b!\u0017:\u0003\u0003%\tea\u0017\t\u0013\ru\u0013(!A\u0005B\r}sACBG\u0001\u0005\u0005\t\u0012A1\u0004\u0010\u001aQ!1\u0017\u0001\u0002\u0002#\u0005\u0011m!%\t\u000f\u00055V\n\"\u0001\u0004*\"I1\u0011L'\u0002\u0002\u0013\u001531\f\u0005\n\u0007Wk\u0015\u0011!CA\u0007[C\u0011ba-N\u0003\u0003%\ti!.\t\u0011\r\u001d\u0007\u0001\"\u0001b\u0007\u0013Dqaa4\u0001\t\u0003\u0019Y\tC\u0004\u0004R\u0002!\taa#\t\u000f\rM\u0007\u0001\"\u0011\u0004\f\"91Q\u001b\u0001\u0005\n\r-\u0005bBBl\u0001\u0011%1\u0011\u001c\u0005\b\u0007K\u0004A\u0011BBF\u0011\u001d\u00199\u000f\u0001C\u0005\u0007SDqaa>\u0001\t#\u0019I\u0010C\u0004\u0004\u0000\u0002!Iaa#\t\u000f\u0011\u0005\u0001\u0001\"\u0003\u0005\u0004!9Aq\u0002\u0001\u0005\u0002\r-\u0005b\u0002C\t\u0001\u0011\u0005A1\u0003\u0005\b\t3\u0001A\u0011\u0001C\u000e\u0005!\t5mY3qi>\u0014(B\u00012d\u0003\u001dqW\r^<pe.T\u0011\u0001Z\u0001\u0006W\u000647.Y\n\u0005\u0001\u0019t\u0017\u000f\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A.\u00198h\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\r=\u0013'.Z2u!\t9w.\u0003\u0002qQ\nA!+\u001e8oC\ndW\r\u0005\u0002sk6\t1O\u0003\u0002uG\u0006)Q\u000f^5mg&\u0011ao\u001d\u0002\b\u0019><w-\u001b8h\u00031\u0019xnY6fiN+'O^3s\u0007\u0001)\u0012A\u001f\t\u0003wrl\u0011!Y\u0005\u0003{\u0006\u0014AbU8dW\u0016$8+\u001a:wKJ\fQb]8dW\u0016$8+\u001a:wKJ\u0004\u0013\u0001C3oIB{\u0017N\u001c;\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1-A\u0004dYV\u001cH/\u001a:\n\t\u00055\u0011q\u0001\u0002\t\u000b:$\u0007k\\5oi\u0006IQM\u001c3Q_&tG\u000fI\u0001\u0007G>tg-[4\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m1-\u0001\u0004tKJ4XM]\u0005\u0005\u0003?\tIBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011QEA\u0019!\u0011\t9#!\f\u000e\u0005\u0005%\"BAA\u0016\u0003\u0015\u00198-\u00197b\u0013\u0011\ty#!\u000b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g1\u0011\u0011!a\u0001\u0003+\t1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\naA\\8eK&#\u0007\u0003BA\u0014\u0003wIA!!\u0010\u0002*\t\u0019\u0011J\u001c;\u0002!\r|gN\\3di&|g.U;pi\u0006\u001cXCAA\"!\rY\u0018QI\u0005\u0004\u0003\u000f\n'\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u0005i&lW\r\u0005\u0003\u0002P\u0005\u0005TBAA)\u0015\r!\u00181\u000b\u0006\u0005\u0003+\n9&\u0001\u0004d_6lwN\u001c\u0006\u0004I\u0006e#\u0002BA.\u0003;\na!\u00199bG\",'BAA0\u0003\ry'oZ\u0005\u0005\u0003G\n\tF\u0001\u0003US6,\u0017\u0001F5t!JLg/\u001b7fO\u0016$G*[:uK:,'\u000f\u0005\u0003\u0002(\u0005%\u0014\u0002BA6\u0003S\u0011qAQ8pY\u0016\fg.\u0001\bsKF,Xm\u001d;DQ\u0006tg.\u001a7\u0011\u0007m\f\t(C\u0002\u0002t\u0005\u0014aBU3rk\u0016\u001cHo\u00115b]:,G.A\u0004nKR\u0014\u0018nY:\u0011\t\u0005e\u0014QP\u0007\u0003\u0003wRA!!\u001e\u0002T%!\u0011qPA>\u0005\u001diU\r\u001e:jGN\f!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feB!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u0006]\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\t\u00055\u0015q\u0011\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!a\u0014\u0002\u0014&!\u0011QSA)\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u000b[\u0016lwN]=Q_>d\u0007\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u00151K\u0001\u0007[\u0016lwN]=\n\t\u0005\r\u0016Q\u0014\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB!\u0011qCAU\u0013\u0011\tY+!\u0007\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u001d\u0003c\u000b\u0019,!.\u00028\u0006e\u00161XA_\u0003\u007f\u000b\t-a1\u0002F\u0006\u001d\u0017\u0011ZAf!\tY\b\u0001C\u0003x'\u0001\u0007!\u0010\u0003\u0004\u0000'\u0001\u0007\u00111\u0001\u0005\b\u0003#\u0019\u0002\u0019AA\u000b\u0011\u001d\t9d\u0005a\u0001\u0003sAq!a\u0010\u0014\u0001\u0004\t\u0019\u0005C\u0004\u0002LM\u0001\r!!\u0014\t\u000f\u0005\u00154\u00031\u0001\u0002h!9\u0011QN\nA\u0002\u0005=\u0004bBA;'\u0001\u0007\u0011q\u000f\u0005\b\u0003\u0003\u001b\u0002\u0019AAB\u0011\u001d\tyi\u0005a\u0001\u0003#Cq!a&\u0014\u0001\u0004\tI\nC\u0004\u0002&N\u0001\r!a*\u0002\u00195,GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\u0005E\u0007\u0003BAj\u00033l!!!6\u000b\t\u0005U\u0014q\u001b\u0006\u0005\u00037\t9&\u0003\u0003\u0002\\\u0006U'!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0011b\u001d5pk2$'+\u001e8\u0016\u0005\u0005\r\b\u0003BAs\u0003gl!!a:\u000b\t\u0005%\u00181^\u0001\u0007CR|W.[2\u000b\t\u00055\u0018q^\u0001\u000bG>t7-\u001e:sK:$(bAAyU\u0006!Q\u000f^5m\u0013\u0011\t)0a:\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003)\u0019\bn\\;mIJ+h\u000eI\u0001\r[\u0016$(/[2Qe\u00164\u0017\u000e\u001f\u000b\u0003\u0003{\u0004B!a@\u0003\u000e9!!\u0011\u0001B\u0005!\u0011\u0011\u0019!!\u000b\u000e\u0005\t\u0015!b\u0001B\u0004q\u00061AH]8pizJAAa\u0003\u0002*\u00051\u0001K]3eK\u001aLAAa\u0004\u0003\u0012\t11\u000b\u001e:j]\u001eTAAa\u0003\u0002*\u0005aA\u000f\u001b:fC\u0012\u0004&/\u001a4jq\u0006q1/\u001a8e\u0005V4g-\u001a:TSj,WC\u0001B\r!\r9'1D\u0005\u0004\u0005;A'aB%oi\u0016<WM]\u0001\u0010g\u0016tGMQ;gM\u0016\u00148+\u001b>fA\u0005q!/Z2w\u0005V4g-\u001a:TSj,\u0017a\u0004:fGZ\u0014UO\u001a4feNK'0\u001a\u0011\u0002#1L7\u000f^3o\u0005\u0006\u001c7\u000e\\8h'&TX-\u0001\nmSN$XM\u001c\"bG.dwnZ*ju\u0016\u0004\u0013a\u00038j_N+G.Z2u_J,\"A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005A1\r[1o]\u0016d7OC\u0002\u00038)\f1A\\5p\u0013\u0011\u0011YD!\r\u0003\u0011M+G.Z2u_J\fAB\\5p'\u0016dWm\u0019;pe\u0002\nQb]3sm\u0016\u00148\t[1o]\u0016dWC\u0001B\"!\u0011\u0011yC!\u0012\n\t\t\u001d#\u0011\u0007\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u0012g\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7`I\u0015\fH\u0003BA\u0013\u0005\u001bB\u0011\"a\r$\u0003\u0003\u0005\rAa\u0011\u0002\u001dM,'O^3s\u0007\"\fgN\\3mA\u0005IAn\\2bYB{'\u000f^\u000b\u0003\u0003s\t!\u0002\\8dC2\u0004vN\u001d;!\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u00057\u0002bA!\u0018\u0003h\t-TB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u000f5,H/\u00192mK*!!QMA\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005S\u0012yFA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA>\u0003n%\u0019!qN1\u0003\u0013A\u0013xnY3tg>\u0014\u0018a\u00039s_\u000e,7o]8sg\u0002\nQD\u00197pG.,G\rU3sG\u0016tG/T3uKJlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0005o\u0002BA!\u001f\u0003\n6\u0011!1\u0010\u0006\u0005\u0005{\u0012y(\u0001\u0003d_J,'\u0002BA;\u0005\u0003SAAa!\u0003\u0006\u00061\u00110Y7nKJT!Aa\"\u0002\u0007\r|W.\u0003\u0003\u0003\f\nm$AC'fiJL7MT1nK\u0006q\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;fe6+GO]5d\u001d\u0006lW\rI\u0001\u0014E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]\u000b\u0003\u0005'\u0003BA!\u001f\u0003\u0016&!!q\u0013B>\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005)2-\u001e:sK:$\bK]8dKN\u001cxN]%oI\u0016D\u0018!G2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r_0%KF$B!!\n\u0003\"\"I\u00111\u0007\u0018\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0017GV\u0014(/\u001a8u!J|7-Z:t_JLe\u000eZ3yA\u0005\u0001B\u000f\u001b:piRdW\rZ*pG.,Go]\u000b\u0003\u0005S\u0003bA!\u0018\u0003,\n=\u0016\u0002\u0002BW\u0005?\u0012Q\u0002\u0015:j_JLG/_)vKV,\u0007c\u0001BYs5\t\u0001A\u0001\nEK2\f\u00170\u001a3DY>\u001cXmU8dW\u0016$8#C\u001d\u00038\nu&q\u001aBk!\u0011\t9C!/\n\t\tm\u0016\u0011\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\r\t}&\u0011\u001aBX\u001d\u0011\u0011\tM!2\u000f\t\t\r!1Y\u0005\u0003\u0003WIAAa2\u0002*\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002Bf\u0005\u001b\u0014qa\u0014:eKJ,GM\u0003\u0003\u0003H\u0006%\u0002\u0003BA\u0014\u0005#LAAa5\u0002*\t9\u0001K]8ek\u000e$\b\u0003\u0002B`\u0005/LAA!7\u0003N\na1+\u001a:jC2L'0\u00192mK\u000611o\\2lKR,\"Aa8\u0011\t\t=\"\u0011]\u0005\u0005\u0005G\u0014\tDA\u0007T_\u000e\\W\r^\"iC:tW\r\\\u0001\bg>\u001c7.\u001a;!\u0003E)g\u000e\u001a+ie>$H\u000f\\3US6,Wj]\u000b\u0003\u0005W\u0004B!a\n\u0003n&!!q^A\u0015\u0005\u0011auN\\4\u0002%\u0015tG\r\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u000b\u0007\u0005_\u0013)Pa>\t\u000f\tmg\b1\u0001\u0003`\"9!q\u001d A\u0002\t-\u0018aB2p[B\f'/\u001a\u000b\u0005\u0003s\u0011i\u0010C\u0004\u0003\u0000~\u0002\rAa,\u0002\tQD\u0017\r^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u00030\u000e\u00151q\u0001\u0005\n\u00057\u0004\u0005\u0013!a\u0001\u0005?D\u0011Ba:A!\u0003\u0005\rAa;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u0002\u0016\u0005\u0005?\u001cya\u000b\u0002\u0004\u0012A!11CB\u000f\u001b\t\u0019)B\u0003\u0003\u0004\u0018\re\u0011!C;oG\",7m[3e\u0015\u0011\u0019Y\"!\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004 \rU!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB\u0013U\u0011\u0011Yoa\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019Y\u0003E\u0002h\u0007[I1Aa\u0004i\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$Ba!\u000e\u0004<A!\u0011qEB\u001c\u0013\u0011\u0019I$!\u000b\u0003\u0007\u0005s\u0017\u0010C\u0005\u00024\u0015\u000b\t\u00111\u0001\u0002:\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004BA111IB#\u0007ki!Aa\u0019\n\t\r\u001d#1\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\r5\u0003\"CA\u001a\u000f\u0006\u0005\t\u0019AB\u001b\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r-21\u000b\u0005\n\u0003gA\u0015\u0011!a\u0001\u0003s\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003s\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007W\ta!Z9vC2\u001cH\u0003BA4\u0007CB\u0011\"a\rL\u0003\u0003\u0005\ra!\u000e\u0002#QD'o\u001c;uY\u0016$7k\\2lKR\u001c\b%A\u0004ti\u0006\u0014H/\u001a3\u0002\u0011M$\u0018M\u001d;fI\u0002\nQb\u001d;beR,GMR;ukJ,WCAB7!\u0019\u0019yg!\u001d\u0004v5\u0011\u00111^\u0005\u0005\u0007g\nYOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042aZB<\u0013\r\u0019I\b\u001b\u0002\u0005->LG-\u0001\bti\u0006\u0014H/\u001a3GkR,(/\u001a\u0011\u0002\rQD'/Z1e+\t\u0019\t\t\u0005\u0003\u0002P\r\r\u0015\u0002BBC\u0003#\u00121bS1gW\u0006$\u0006N]3bI\u00069A\u000f\u001b:fC\u0012\u0004\u0013!B:uCJ$HCAA\u0013\u0003I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0011\u0007\tEVjE\u0003N\u0007'\u001by\n\u0005\u0006\u0004\u0016\u000em%q\u001cBv\u0005_k!aa&\u000b\t\re\u0015\u0011F\u0001\beVtG/[7f\u0013\u0011\u0019ija&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004\"\u000e\u001dVBABR\u0015\r\u0019)K[\u0001\u0003S>LAA!7\u0004$R\u00111qR\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005_\u001byk!-\t\u000f\tm\u0007\u000b1\u0001\u0003`\"9!q\u001d)A\u0002\t-\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0007o\u001b\u0019\r\u0005\u0004\u0002(\re6QX\u0005\u0005\u0007w\u000bIC\u0001\u0004PaRLwN\u001c\t\t\u0003O\u0019yLa8\u0003l&!1\u0011YA\u0015\u0005\u0019!V\u000f\u001d7fe!I1QY)\u0002\u0002\u0003\u0007!qV\u0001\u0004q\u0012\u0002\u0014\u0001\u0005:f[>4X\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\t)ca3\t\u000f\r5'\u000b1\u0001\u0002:\u0005Y!/Z7pm\u0016\u001cu.\u001e8u\u00035\u0011WmZ5o'\",H\u000fZ8x]\u0006)1\r\\8tK\u0006\u0019!/\u001e8\u0002\u0011\rdwn]3BY2\f\u0001c\u001c9f]N+'O^3s'>\u001c7.\u001a;\u0015\u0011\t\r31\\Bp\u0007GDqa!8X\u0001\u0004\ti0\u0001\u0003i_N$\bbBBq/\u0002\u0007\u0011\u0011H\u0001\u0005a>\u0014H\u000fC\u0004\u0003&]\u0003\r!!\u000f\u0002)\u0005\u001c7-\u001a9u\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\u0019\t7mY3qiR!11^Bw!\u0019\t9c!/\u0003`\"91q^-A\u0002\rE\u0018aA6fsB!!qFBz\u0013\u0011\u0019)P!\r\u0003\u0019M+G.Z2uS>t7*Z=\u0002=\r|gNZ5hkJ,\u0017iY2faR,GmU8dW\u0016$8\t[1o]\u0016dG\u0003BA\u0013\u0007wDqa!@[\u0001\u0004\u0011y.A\u0007t_\u000e\\W\r^\"iC:tW\r\\\u0001\u001aG2|7/\u001a+ie>$H\u000f\\3e\u0007>tg.Z2uS>t7/A\nbgNLwM\u001c(fo\u000e{gN\\3di&|g\u000e\u0006\u0005\u0002h\u0011\u0015Aq\u0001C\u0006\u0011\u001d\u0019i\u0010\u0018a\u0001\u0005?Dq\u0001\"\u0003]\u0001\u0004\u0011Y'A\u0005qe>\u001cWm]:pe\"9AQ\u0002/A\u0002\u0005\u001d\u0014\u0001C7bs\ncwnY6\u0002\r]\f7.Z;q\u00035\tG\r\u001a)s_\u000e,7o]8sgR!\u0011Q\u0005C\u000b\u0011\u001d!9B\u0018a\u0001\u0003s\t\u0001\u0002^8De\u0016\fG/Z\u0001\r]\u0016<\bK]8dKN\u001cxN\u001d\u000b\t\u0005W\"i\u0002\"\t\u00050!9AqD0A\u0002\u0005e\u0012AA5e\u0011\u001d!\u0019c\u0018a\u0001\tK\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B\u0001b\n\u0005,5\u0011A\u0011\u0006\u0006\u0004E\u0006M\u0013\u0002\u0002C\u0017\tS\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq\u0001\"\r`\u0001\u0004!\u0019$\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!AQ\u0007C\u001f\u001b\t!9D\u0003\u0003\u0005:\u0011m\u0012\u0001B1vi\"TA!!#\u0002T%!Aq\bC\u001c\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G\u000e")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private final AtomicBoolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$16 -> {
                    x$16.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        if (!this.started().get()) {
            this.closeAll();
        }
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$17 -> {
                x$17.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.closeAll();
        }
    }

    private void closeAll() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
        this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
            SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
            return BoxedUnit.UNIT;
        });
        this.throttledSockets().clear();
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        try {
            serverChannel.configureBlocking(false);
            if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
                serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
            }
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            Utils.closeQuietly((AutoCloseable)serverChannel, (String)"server socket");
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$18)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started().get()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Opened endpoint ").append(this.endPoint().host()).append(":").append(this.endPoint().port()).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
            this.processors().foreach((Function1 & Serializable)x$14 -> {
                x$14.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started().set(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Refusing to start acceptor for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException(new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$18) {
        return x$18.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Opened wildcard endpoint ").append(this.endPoint().host()).append(":").append(newPort).toString());
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.network", (String)"Acceptor", (String)new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))).asJava());
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = new AtomicBoolean();
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

