/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;

public class DelayedShareFetchGroupKey
implements DelayedShareFetchKey {
    private final String groupId;
    private final Uuid topicId;
    private final int partition;

    public DelayedShareFetchGroupKey(String groupId, Uuid topicId, int partition) {
        this.groupId = groupId;
        this.topicId = topicId;
        this.partition = partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayedShareFetchGroupKey that = (DelayedShareFetchGroupKey)o;
        return this.topicId.equals((Object)that.topicId) && this.partition == that.partition && this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        return Objects.hash(this.topicId, this.partition, this.groupId);
    }

    public String toString() {
        return "DelayedShareFetchGroupKey(groupId=" + this.groupId + ", topicId=" + String.valueOf(this.topicId) + ", partition=" + this.partition + ")";
    }

    public String keyLabel() {
        return String.format("groupId=%s, topicId=%s, partition=%s", this.groupId, this.topicId, this.partition);
    }
}

