/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class TransactionStateManagerConfig {
    public static final String TRANSACTIONS_MAX_TIMEOUT_MS_CONFIG = "transaction.max.timeout.ms";
    public static final int TRANSACTIONS_MAX_TIMEOUT_MS_DEFAULT = (int)TimeUnit.MINUTES.toMillis(15L);
    public static final String TRANSACTIONS_MAX_TIMEOUT_MS_DOC = "The maximum allowed timeout for transactions. If a client\u2019s requested transaction time exceed this, then the broker will return an error in InitProducerIdRequest. This prevents a client from too large of a timeout, which can stall consumers reading from topics included in the transaction.";
    public static final String TRANSACTIONAL_ID_EXPIRATION_MS_CONFIG = "transactional.id.expiration.ms";
    public static final int TRANSACTIONAL_ID_EXPIRATION_MS_DEFAULT = (int)TimeUnit.DAYS.toMillis(7L);
    public static final String TRANSACTIONAL_ID_EXPIRATION_MS_DOC = "The time in ms that the transaction coordinator will wait without receiving any transaction status updates for the current transaction before expiring its transactional id. Transactional IDs will not expire while a the transaction is still ongoing.";
    public static final String TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTION_CLEANUP_INTERVAL_MS_CONFIG = "transaction.abort.timed.out.transaction.cleanup.interval.ms";
    public static final int TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTION_CLEANUP_INTERVAL_MS_DEFAULT = (int)TimeUnit.SECONDS.toMillis(10L);
    public static final String TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTIONS_INTERVAL_MS_DOC = "The interval at which to rollback transactions that have timed out";
    public static final String TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONAL_ID_CLEANUP_INTERVAL_MS_CONFIG = "transaction.remove.expired.transaction.cleanup.interval.ms";
    public static final int TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONAL_ID_CLEANUP_INTERVAL_MS_DEFAULT = (int)TimeUnit.HOURS.toMillis(1L);
    public static final String TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONS_INTERVAL_MS_DOC = "The interval at which to remove transactions that have expired due to <code>transactional.id.expiration.ms</code> passing";
    public static final String METRICS_GROUP = "transaction-coordinator-metrics";
    public static final String LOAD_TIME_SENSOR = "TransactionsPartitionLoadTime";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("transactional.id.expiration.ms", ConfigDef.Type.INT, (Object)TRANSACTIONAL_ID_EXPIRATION_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The time in ms that the transaction coordinator will wait without receiving any transaction status updates for the current transaction before expiring its transactional id. Transactional IDs will not expire while a the transaction is still ongoing.").define("transaction.max.timeout.ms", ConfigDef.Type.INT, (Object)TRANSACTIONS_MAX_TIMEOUT_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The maximum allowed timeout for transactions. If a client\u2019s requested transaction time exceed this, then the broker will return an error in InitProducerIdRequest. This prevents a client from too large of a timeout, which can stall consumers reading from topics included in the transaction.").define("transaction.abort.timed.out.transaction.cleanup.interval.ms", ConfigDef.Type.INT, (Object)TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTION_CLEANUP_INTERVAL_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The interval at which to rollback transactions that have timed out").define("transaction.remove.expired.transaction.cleanup.interval.ms", ConfigDef.Type.INT, (Object)TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONAL_ID_CLEANUP_INTERVAL_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The interval at which to remove transactions that have expired due to <code>transactional.id.expiration.ms</code> passing");
    private final int transactionalIdExpirationMs;
    private final int transactionMaxTimeoutMs;
    private final int transactionAbortTimedOutTransactionCleanupIntervalMs;
    private final int transactionRemoveExpiredTransactionalIdCleanupIntervalMs;

    public TransactionStateManagerConfig(AbstractConfig config) {
        this.transactionalIdExpirationMs = config.getInt(TRANSACTIONAL_ID_EXPIRATION_MS_CONFIG);
        this.transactionMaxTimeoutMs = config.getInt(TRANSACTIONS_MAX_TIMEOUT_MS_CONFIG);
        this.transactionAbortTimedOutTransactionCleanupIntervalMs = config.getInt(TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTION_CLEANUP_INTERVAL_MS_CONFIG);
        this.transactionRemoveExpiredTransactionalIdCleanupIntervalMs = config.getInt(TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONAL_ID_CLEANUP_INTERVAL_MS_CONFIG);
    }

    public int transactionalIdExpirationMs() {
        return this.transactionalIdExpirationMs;
    }

    public int transactionMaxTimeoutMs() {
        return this.transactionMaxTimeoutMs;
    }

    public int transactionAbortTimedOutTransactionCleanupIntervalMs() {
        return this.transactionAbortTimedOutTransactionCleanupIntervalMs;
    }

    public int transactionRemoveExpiredTransactionalIdCleanupIntervalMs() {
        return this.transactionRemoveExpiredTransactionalIdCleanupIntervalMs;
    }
}

