/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="source", description="Run a script")
@Service
public class SourceAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Argument(index=0, name="script", description="A URI pointing to the script", required=true, multiValued=false)
    private URI script;
    @Argument(index=1, name="args", description="Arguments for the script", required=false, multiValued=true)
    private List<Object> args;
    @Reference
    Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        BufferedReader reader = null;
        Object arg0 = this.session.get("0");
        try {
            int n;
            try {
                URL url = this.script.toURL();
                this.log.info("Printing URL: " + url);
                reader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (IllegalArgumentException | MalformedURLException ignore) {
                Path file = this.session.currentDir().resolve(this.script.getPath());
                this.log.info("Printing file: " + file);
                reader = new BufferedReader(Files.newBufferedReader(file));
            }
            CharArrayWriter w = new CharArrayWriter();
            char[] buf = new char[8192];
            while ((n = reader.read(buf)) > 0) {
                w.write(buf, 0, n);
            }
            for (int i = 0; this.args != null && i < this.args.size(); ++i) {
                this.session.put(Integer.toString(i + 1), this.args.get(i));
            }
            this.session.execute((CharSequence)w.toString());
        }
        finally {
            for (int i = 0; this.args != null && i < this.args.size(); ++i) {
                this.session.put(Integer.toString(i + 1), null);
            }
            this.session.put("0", arg0);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

