/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class NumericOidSyntaxChecker
extends SyntaxChecker {
    public static final NumericOidSyntaxChecker INSTANCE = new NumericOidSyntaxChecker("1.3.6.1.4.1.18060.0.4.0.0.2");

    private NumericOidSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean result = Oid.isOid(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<NumericOidSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.0.0.2");
        }

        @Override
        public NumericOidSyntaxChecker build() {
            return new NumericOidSyntaxChecker(this.oid);
        }
    }
}

