/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.net.SocketAddress;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;

public class DelegatingAuthenticator
extends AbstractAuthenticator {
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private String delegateHost;
    private int delegatePort;
    private boolean delegateSsl;
    private boolean delegateTls;
    private String delegateSslTrustManagerFQCN;
    private String delegateTlsTrustManagerFQCN;

    public DelegatingAuthenticator() {
        super(AuthenticationLevel.SIMPLE);
    }

    public DelegatingAuthenticator(Dn baseDn) {
        super(AuthenticationLevel.SIMPLE, baseDn);
    }

    protected DelegatingAuthenticator(AuthenticationLevel type, Dn baseDn) {
        super(type, baseDn);
    }

    public String getDelegateHost() {
        return this.delegateHost;
    }

    public void setDelegateHost(String delegateHost) {
        this.delegateHost = delegateHost;
    }

    public int getDelegatePort() {
        return this.delegatePort;
    }

    public void setDelegatePort(int delegatePort) {
        this.delegatePort = delegatePort;
    }

    public boolean isDelegateSsl() {
        return this.delegateSsl;
    }

    public void setDelegateSsl(boolean delegateSsl) {
        this.delegateSsl = delegateSsl;
    }

    public String getDelegateBaseDn() {
        return this.getBaseDn().toString();
    }

    public boolean isDelegateTls() {
        return this.delegateTls;
    }

    public void setDelegateTls(boolean delegateTls) {
        this.delegateTls = delegateTls;
    }

    public String getDelegateSslTrustManagerFQCN() {
        return this.delegateSslTrustManagerFQCN;
    }

    public void setDelegateSslTrustManagerFQCN(String delegateSslTrustManagerFQCN) {
        this.delegateSslTrustManagerFQCN = delegateSslTrustManagerFQCN;
    }

    public String getDelegateTlsTrustManagerFQCN() {
        return this.delegateTlsTrustManagerFQCN;
    }

    public void setDelegateTlsTrustManagerFQCN(String delegateTlsTrustManagerFQCN) {
        this.delegateTlsTrustManagerFQCN = delegateTlsTrustManagerFQCN;
    }

    @Override
    public LdapPrincipal authenticate(BindOperationContext bindContext) throws Exception {
        LdapNetworkConnection ldapConnection;
        LdapPrincipal principal = null;
        if (IS_DEBUG) {
            LOG.debug("Authenticating {}", (Object)bindContext.getDn());
        }
        Dn bindDn = bindContext.getDn();
        if (this.getBaseDn() == null || !bindDn.isDescendantOf(this.getBaseDn())) {
            return null;
        }
        if (this.delegateTls) {
            LdapConnectionConfig connectionConfig = new LdapConnectionConfig();
            connectionConfig.setLdapHost(this.delegateHost);
            connectionConfig.setLdapPort(this.delegatePort);
            connectionConfig.setTrustManagers(new NoVerificationTrustManager());
            ldapConnection = new LdapNetworkConnection(connectionConfig);
            ldapConnection.connect();
            ldapConnection.startTls();
        } else if (this.delegateSsl) {
            LdapConnectionConfig connectionConfig = new LdapConnectionConfig();
            connectionConfig.setLdapHost(this.delegateHost);
            connectionConfig.setUseSsl(true);
            connectionConfig.setLdapPort(this.delegatePort);
            connectionConfig.setTrustManagers(new NoVerificationTrustManager());
            ldapConnection = new LdapNetworkConnection(connectionConfig);
            ldapConnection.connect();
        } else {
            LdapConnectionConfig connectionConfig = new LdapConnectionConfig();
            connectionConfig.setLdapHost(this.delegateHost);
            connectionConfig.setLdapPort(this.delegatePort);
            ldapConnection = new LdapNetworkConnection(this.delegateHost, this.delegatePort);
            ldapConnection.connect();
        }
        ldapConnection.setTimeOut(0L);
        try {
            Object clientAddress;
            try {
                ldapConnection.bind(bindDn, Strings.utf8ToString(bindContext.getCredentials()));
                ldapConnection.unBind();
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_230, bindDn.getName());
                LOG.info(message);
                throw new LdapAuthenticationException(message);
            }
            principal = new LdapPrincipal(this.getDirectoryService().getSchemaManager(), bindDn, AuthenticationLevel.SIMPLE, bindContext.getCredentials());
            IoSession session = bindContext.getIoSession();
            if (session != null) {
                clientAddress = session.getRemoteAddress();
                principal.setClientAddress((SocketAddress)clientAddress);
                SocketAddress serverAddress = session.getServiceAddress();
                principal.setServerAddress(serverAddress);
            }
            clientAddress = principal;
            return clientAddress;
        }
        catch (LdapException e) {
            String message = I18n.err(I18n.ERR_230, bindDn.getName());
            LOG.info(message);
            throw new LdapAuthenticationException(message);
        }
        finally {
            ldapConnection.close();
        }
    }

    @Override
    public void checkPwdPolicy(Entry userEntry) throws LdapException {
    }

    @Override
    public void invalidateCache(Dn bindDn) {
    }
}

