/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.ByteArrayComparator;
import org.apache.directory.api.ldap.model.schema.comparators.StringComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.evaluator.LeafEvaluator;

public class EqualityEvaluator<T>
extends LeafEvaluator<T> {
    private static final Comparator<byte[]> BINARY_COMPARATOR = new ByteArrayComparator(null);
    private static final Comparator<String> STRING_COMPARATOR = new StringComparator(null);

    public EqualityEvaluator(EqualityNode<T> node, Store db, SchemaManager schemaManager) throws Exception {
        super(node, db, schemaManager);
        MatchingRule mr;
        if (db.hasIndexOn(this.attributeType)) {
            this.idx = db.getIndex(this.attributeType);
        }
        if ((mr = this.attributeType.getEquality()) == null) {
            this.normalizer = new NoOpNormalizer(this.attributeType.getOid());
            this.ldapComparator = null;
        } else {
            this.normalizer = mr.getNormalizer();
            this.ldapComparator = mr.getLdapComparator();
        }
    }

    @Override
    public EqualityNode<T> getExpression() {
        return (EqualityNode)this.node;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws LdapException {
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        return this.evaluate(entry);
    }

    @Override
    public boolean evaluate(Entry entry) throws LdapException {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null && this.evaluate(attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = entry.get(descendant);
                if (attr == null || !this.evaluate(attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(Attribute attribute) throws LdapException {
        if (attribute.contains(this.node.getValue())) {
            return true;
        }
        for (Value value : attribute) {
            Object nodeValue;
            Object serverValue;
            if (value.isHumanReadable()) {
                serverValue = (String)value.getNormValue();
                nodeValue = null;
                nodeValue = this.node.getValue().isHumanReadable() ? (Object)((String)this.node.getValue().getNormValue()) : (Object)Strings.utf8ToString((byte[])this.node.getValue().getNormValue());
                if (!(this.ldapComparator != null ? this.ldapComparator.compare(serverValue, nodeValue) == 0 : STRING_COMPARATOR.compare((String)serverValue, (String)nodeValue) == 0)) continue;
                return true;
            }
            serverValue = (byte[])value.getNormValue();
            nodeValue = (byte[])this.node.getValue().getNormValue();
            if (!(this.ldapComparator != null ? this.ldapComparator.compare(serverValue, nodeValue) == 0 : BINARY_COMPARATOR.compare((byte[])serverValue, (byte[])nodeValue) == 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("EqualityEvaluator : ").append(super.toString()).append('\n');
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

