/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class AccessHandler
extends AbstractLifeCycle
implements RequestLog {
    private static Logger log = Logger.getLogger((String)"org.apache.knox.gateway.access");

    public void log(Request request, Response response) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            TraceUtil.appendCorrelationContext(sb);
            sb.append("|");
            sb.append(request.getRemoteAddr());
            sb.append("|");
            sb.append(request.getMethod());
            sb.append("|");
            sb.append(request.getHttpURI());
            sb.append("|");
            sb.append(request.getContentLength());
            sb.append("|");
            sb.append(response.getStatus());
            sb.append("|");
            sb.append(response.getContentCount());
            sb.append("|");
            sb.append(System.currentTimeMillis() - request.getTimeStamp());
            log.trace((Object)sb);
        }
    }
}

