/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.FacebookApi;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.facebook.FacebookConfiguration;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oauth.profile.facebook.FacebookProfileCreator;
import org.pac4j.oauth.profile.facebook.FacebookProfileDefinition;

public class FacebookClient
extends OAuth20Client<FacebookProfile> {
    public FacebookClient() {
        this.configuration = new FacebookConfiguration();
    }

    public FacebookClient(String key, String secret) {
        this.configuration = new FacebookConfiguration();
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        CommonHelper.assertNotBlank((String)"fields", (String)this.getConfiguration().getFields());
        this.configuration.setApi(FacebookApi.instance());
        this.configuration.setProfileDefinition(new FacebookProfileDefinition());
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorReason = ctx.getRequestParameter("error_reason");
            if ("access_denied".equals(error) && "user_denied".equals(errorReason)) {
                return true;
            }
            return false;
        });
        this.configuration.setWithState(true);
        this.defaultProfileCreator(new FacebookProfileCreator(this.configuration, (IndirectClient)this));
        super.clientInit();
    }

    @Override
    public FacebookConfiguration getConfiguration() {
        return (FacebookConfiguration)this.configuration;
    }

    public void setStateData(String stateData) {
        this.configuration.setStateData(stateData);
    }

    public String getStateData() {
        return this.configuration.getStateData();
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }

    public String getFields() {
        return this.getConfiguration().getFields();
    }

    public void setFields(String fields) {
        this.getConfiguration().setFields(fields);
    }

    public int getLimit() {
        return this.getConfiguration().getLimit();
    }

    public void setLimit(int limit) {
        this.getConfiguration().setLimit(limit);
    }
}

