/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;

@Path(value="/api/v1")
public class AliasResource {
    private static final String ALIASES_API_PATH = "aliases";
    private static final String ALIASES_TOPOLOGY_API_PATH = "aliases/{topology}";
    private static final String ALIAS_API_PATH = "aliases/{topology}/{alias}";
    @Context
    private HttpServletRequest request;

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json", "text/plain"})
    @Path(value="aliases/{topology}/{alias}")
    public Response putAlias(@PathParam(value="topology") String topology, @PathParam(value="alias") String alias, String value) {
        return this.postAlias(topology, alias, value);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="aliases/{topology}/{alias}")
    public Response postAlias(@PathParam(value="topology") String topology, @PathParam(value="alias") String alias, @FormParam(value="value") String value) {
        if (value == null || value.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Alias value cannot be null or blank").type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        AliasService as = this.getAliasService();
        try {
            as.addAliasForCluster(topology, alias, value);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("{ \"created\" : { \"topology\": \"" + topology + "\", \"alias\": \"" + alias + "\" } }")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (AliasServiceException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error adding alias " + alias + " for cluster " + topology + ", reason: " + e.toString())).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="aliases/{topology}/{alias}")
    public Response deleteAlias(@PathParam(value="topology") String topology, @PathParam(value="alias") String alias) {
        AliasService as = this.getAliasService();
        try {
            as.removeAliasForCluster(topology, alias);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("{ \"deleted\" : { \"topology\": \"" + topology + "\", \"alias\": \"" + alias + "\" } }")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (AliasServiceException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error deleting alias " + alias + " for cluster " + topology + ", reason: " + e.toString())).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="aliases/{topology}")
    public Response getAliases(@PathParam(value="topology") String topology) {
        ObjectMapper mapper = new ObjectMapper();
        AliasService as = this.getAliasService();
        try {
            List aliases = as.getAliasesForCluster(topology);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)mapper.writeValueAsString((Object)new TopologyAliases(topology, aliases))).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting aliases for cluster " + topology + ", reason: " + e.toString())).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    private AliasService getAliasService() {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        return (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
    }

    public static class TopologyAliases {
        private String topology;
        private List<String> aliases;

        public TopologyAliases(String topology, List<String> aliases) {
            this.topology = topology;
            this.aliases = aliases;
        }

        public String getTopology() {
            return this.topology;
        }

        public void setTopology(String topology) {
            this.topology = topology;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }
    }
}

