/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletContextListener;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletFilter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public class UrlRewriteDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String PROVIDER_ROLE_NAME = "rewrite";
    private static final String PROVIDER_IMPL_NAME = "url-rewrite";
    private static final String PARAM_SERVICE_ROLE = "service.role";
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void initializeContribution(DeploymentContext context) {
        context.addDescriptor(this.getRole(), (Object)UrlRewriteRulesDescriptorFactory.create());
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void finalizeContribution(DeploymentContext context) {
        UrlRewriteRulesDescriptor descriptor = (UrlRewriteRulesDescriptor)context.getDescriptor(this.getRole());
        StringWriter writer = new StringWriter();
        try {
            UrlRewriteRulesDescriptorFactory.store(descriptor, "xml", writer);
        }
        catch (IOException e) {
            LOG.failedToWriteRulesDescriptor((Exception)e);
        }
        String asset = writer.toString();
        context.getWebArchive().addAsWebInfResource((Asset)new StringAsset(asset), "rewrite.xml");
        context.getWebAppDescriptor().createListener().listenerClass(UrlRewriteServletContextListener.class.getName());
        context.getWebAppDescriptor().createContextParam().paramName("rewriteDescriptorLocation").paramValue("/WEB-INF/rewrite.xml");
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        FilterDescriptor filterDescriptor = resource.addFilter();
        filterDescriptor.role(this.getRole()).name(this.getName()).impl(UrlRewriteServletFilter.class).params(params);
        filterDescriptor.param().name(PARAM_SERVICE_ROLE).value(service.getRole());
    }
}

