/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.SingletonEnumeration;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreKeyStoreSpi
extends KeyStoreSpi {
    private static final String APACHEDS_ALIAS = "apacheds";
    private static final Logger LOG = LoggerFactory.getLogger(CoreKeyStoreSpi.class);
    private DirectoryService directoryService;
    private KeyStore keyStore;

    public CoreKeyStoreSpi(DirectoryService directoryService) {
        LOG.debug("Constructor called.");
        this.directoryService = directoryService;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    private Entry getTlsEntry() throws LdapException {
        Dn adminDn = this.directoryService.getDnFactory().create("uid=admin,ou=system");
        return this.directoryService.getAdminSession().lookup(adminDn, new String[0]);
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOG.debug("engineAliases() called.");
        return new SingletonEnumeration((Object)APACHEDS_ALIAS);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOG.debug("engineContainsAlias({}) called.", (Object)alias);
        return alias.equalsIgnoreCase(APACHEDS_ALIAS);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LOG.debug("engineDeleteEntry({}) called.", (Object)alias);
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        LOG.debug("engineGetCertificate({}) called.", (Object)alias);
        if (alias.equalsIgnoreCase(APACHEDS_ALIAS)) {
            try {
                return this.keyStore.getCertificate(alias);
            }
            catch (Exception e) {
                LOG.error(I18n.err((I18n)I18n.ERR_65, (Object[])new Object[0]), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        LOG.debug("engineGetCertificateAlias({}) called.", (Object)cert);
        if (cert instanceof X509Certificate) {
            LOG.debug("Certificate in alias request is X.509 based.");
            X509Certificate xcert = (X509Certificate)cert;
            if (xcert.getIssuerDN().toString().equals("CN=ApacheDS,OU=Directory, O=ASF, C=US")) {
                return APACHEDS_ALIAS;
            }
        }
        try {
            Certificate certificate = this.keyStore.getCertificate(APACHEDS_ALIAS);
            if (Objects.deepEquals(cert.getEncoded(), certificate.getEncoded())) {
                return APACHEDS_ALIAS;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_66, (Object[])new Object[0]), (Throwable)e);
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOG.debug("engineGetCertificateChain({}) called.", (Object)alias);
        try {
            Entry entry = this.getTlsEntry();
            LOG.debug("Entry:\n{}", (Object)entry);
            return new Certificate[]{this.keyStore.getCertificate(alias)};
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_66, (Object[])new Object[0]), (Throwable)e);
            return new Certificate[0];
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOG.debug("engineGetCreationDate({}) called.", (Object)alias);
        return new Date();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOG.debug("engineGetKey({}, {}) called.", (Object)alias, (Object)password);
        try {
            return this.keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_68, (Object[])new Object[0]), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOG.debug("engineIsCertificateEntry({}) called.", (Object)alias);
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOG.debug("engineIsKeyEntry({}) called.", (Object)alias);
        return true;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("engineLoad({}, {}) called.", (Object)stream, (Object)password);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        LOG.debug("engineSetCertificateEntry({}, {}) called.", (Object)alias, (Object)cert);
        throw new NotImplementedException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        LOG.debug("engineSetKeyEntry({}, key, {}) called.", (Object)alias, (Object)chain);
        throw new NotImplementedException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("engineSetKeyEntry({}, key, {}, chain) called.", (Object)alias, (Object)new String(password));
        }
        throw new NotImplementedException();
    }

    @Override
    public int engineSize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("engineSize() called.");
        }
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("engineStore(stream, {}) called.", (Object)new String(password));
        }
    }
}

