/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2MessageSender;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jHTTPPostSimpleSignEncoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2MessageSender<T extends SAMLObject>
implements SAML2MessageSender<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected final String destinationBindingType;
    protected final boolean signErrorResponses;
    protected final boolean isRequestSigned;

    public AbstractSAML2MessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean signErrorResponses, boolean isRequestSigned) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
        this.destinationBindingType = destinationBindingType;
        this.signErrorResponses = signErrorResponses;
        this.isRequestSigned = isRequestSigned;
    }

    @Override
    public void sendMessage(SAML2MessageContext context, T request, Object relayState) {
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        IDPSSODescriptor idpssoDescriptor = context.getIDPSSODescriptor();
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        MessageEncoder encoder = this.getMessageEncoder(spDescriptor, idpssoDescriptor, context);
        SAML2MessageContext outboundContext = new SAML2MessageContext(context);
        outboundContext.getProfileRequestContext().setProfileId(context.getProfileRequestContext().getProfileId());
        outboundContext.getProfileRequestContext().setInboundMessageContext(context.getProfileRequestContext().getInboundMessageContext());
        outboundContext.getProfileRequestContext().setOutboundMessageContext(context.getProfileRequestContext().getOutboundMessageContext());
        outboundContext.setMessage(request);
        outboundContext.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        outboundContext.getSAMLPeerEndpointContext().setEndpoint(this.getEndpoint(context));
        outboundContext.getSAMLPeerEntityContext().setRole(context.getSAMLPeerEntityContext().getRole());
        outboundContext.getSAMLPeerEntityContext().setEntityId(context.getSAMLPeerEntityContext().getEntityId());
        outboundContext.getSAMLProtocolContext().setProtocol(context.getSAMLProtocolContext().getProtocol());
        outboundContext.getSecurityParametersContext().setSignatureSigningParameters(this.signatureSigningParametersProvider.build((SSODescriptor)spDescriptor));
        if (relayState != null) {
            outboundContext.getSAMLBindingContext().setRelayState(relayState.toString());
        }
        try {
            this.invokeOutboundMessageHandlers(spDescriptor, idpssoDescriptor, outboundContext);
            encoder.setMessageContext((MessageContext)outboundContext);
            encoder.initialize();
            encoder.prepareContext();
            encoder.encode();
            SAMLMessageStorage messageStorage = context.getSAMLMessageStorage();
            if (messageStorage != null) {
                if (request instanceof RequestAbstractType) {
                    messageStorage.storeMessage(((RequestAbstractType)request).getID(), (XMLObject)request);
                } else if (request instanceof StatusResponseType) {
                    messageStorage.storeMessage(((StatusResponseType)request).getID(), (XMLObject)request);
                }
            }
        }
        catch (MessageEncodingException e) {
            throw new SAMLException("Error encoding saml message", e);
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing saml encoder", e);
        }
    }

    protected abstract Endpoint getEndpoint(SAML2MessageContext var1);

    protected final void invokeOutboundMessageHandlers(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext outboundContext) {
        try {
            EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
            handlerEnd.initialize();
            handlerEnd.invoke((MessageContext)outboundContext);
            SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
            handlerDest.initialize();
            handlerDest.invoke((MessageContext)outboundContext);
            if (!this.destinationBindingType.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") && this.mustSignRequest(spDescriptor, idpssoDescriptor)) {
                this.logger.debug("Signing SAML2 outbound context...");
                SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
                handler.setSignErrorResponses(this.signErrorResponses);
                handler.invoke((MessageContext)outboundContext);
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected boolean mustSignRequest(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor) {
        return this.isRequestSigned;
    }

    private MessageEncoder getMessageEncoder(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext ctx) {
        Pac4jSAMLResponse adapter = ctx.getProfileRequestContextOutboundMessageTransportResponse();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostEncoder encoder = new Pac4jHTTPPostEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostSimpleSignEncoder encoder = new Pac4jHTTPPostSimpleSignEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            return new Pac4jHTTPRedirectDeflateEncoder(adapter, this.mustSignRequest(spDescriptor, idpssoDescriptor));
        }
        throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
    }
}

