/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl.state;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.token.impl.state.FileTokenStateJournal;
import org.apache.knox.gateway.services.token.state.JournalEntry;

class MultiFileTokenStateJournal
extends FileTokenStateJournal {
    static final String ENTRY_FILE_EXT = ".ts";
    static final String ENTRY_FILE_EXT_FILTER = "*.ts";

    MultiFileTokenStateJournal(GatewayConfig config) throws IOException {
        super(config);
    }

    @Override
    public void add(String tokenId, long issueTime, long expiration, long maxLifetime) throws IOException {
        this.add(Collections.singletonList(new FileTokenStateJournal.FileJournalEntry(tokenId, issueTime, expiration, maxLifetime)));
    }

    @Override
    public void add(List<JournalEntry> entries) throws IOException {
        for (JournalEntry entry : entries) {
            Path entryFile = this.journalDir.resolve(entry.getTokenId() + ENTRY_FILE_EXT);
            log.persistingJournalEntry(entryFile.toString());
            try {
                FileChannel fileChannel = FileChannel.open(entryFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Throwable throwable = null;
                try {
                    fileChannel.lock();
                    try (OutputStream out = Channels.newOutputStream(fileChannel);){
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                        writer.write(entry.toString());
                        writer.newLine();
                        writer.flush();
                    }
                    log.addedJournalEntry(entry.getTokenId());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileChannel == null) continue;
                    if (throwable != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                log.failedToPersistJournalEntry(entry.getTokenId(), e);
                throw e;
            }
        }
    }

    @Override
    public JournalEntry get(String tokenId) throws IOException {
        JournalEntry result = null;
        Path entryFilePath = this.journalDir.resolve(tokenId + ENTRY_FILE_EXT);
        if (Files.exists(entryFilePath, new LinkOption[0])) {
            try (FileChannel fileChannel = FileChannel.open(entryFilePath, StandardOpenOption.READ);){
                fileChannel.lock(0L, Long.MAX_VALUE, true);
                List<FileTokenStateJournal.FileJournalEntry> entries = this.loadJournal(fileChannel);
                if (entries.isEmpty()) {
                    log.journalEntryNotFound(tokenId);
                }
                result = entries.get(0);
            }
        } else {
            log.journalEntryNotFound(tokenId);
        }
        return result;
    }

    @Override
    public void remove(Collection<String> tokenIds) throws IOException {
        for (String tokenId : tokenIds) {
            Path entryFilePath = this.journalDir.resolve(tokenId + ENTRY_FILE_EXT);
            if (!Files.exists(entryFilePath, new LinkOption[0])) continue;
            Files.delete(entryFilePath);
            log.removedJournalEntry(tokenId);
        }
    }

    @Override
    protected List<JournalEntry> loadJournal() throws IOException {
        ArrayList<JournalEntry> entries = new ArrayList<JournalEntry>();
        if (Files.exists(this.journalDir, new LinkOption[0])) {
            log.loadingPersistedJournalEntries();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.journalDir, ENTRY_FILE_EXT_FILTER);){
                for (Path entryFilePath : stream) {
                    FileChannel fileChannel = FileChannel.open(entryFilePath, StandardOpenOption.READ);
                    Throwable throwable = null;
                    try {
                        fileChannel.lock(0L, Long.MAX_VALUE, true);
                        entries.addAll(this.loadJournal(fileChannel));
                        if (entries.isEmpty()) {
                            log.emptyJournalEntry(entryFilePath.toString());
                            continue;
                        }
                        log.loadedPersistedJournalEntry(((JournalEntry)entries.get(0)).getTokenId());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileChannel == null) continue;
                        if (throwable != null) {
                            try {
                                fileChannel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileChannel.close();
                    }
                }
            }
        }
        return entries;
    }
}

