/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.config.remote.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryConfig;
import org.apache.knox.gateway.service.config.remote.config.DefaultRemoteConfigurationRegistries;
import org.apache.knox.gateway.service.config.remote.config.RemoteConfigurationRegistries;
import org.apache.knox.gateway.service.config.remote.config.RemoteConfigurationRegistriesParser;

public class RemoteConfigurationRegistriesAccessor {
    private static final String XML_CONFIG_REFERENCE_SYSTEM_PROPERTY_NAME = "org.apache.knox.gateway.remote.registry.config.file";

    public static List<RemoteConfigurationRegistryConfig> getRemoteRegistryConfigurations(GatewayConfig gatewayConfig) {
        File remoteConfigRegistryConfigFile;
        ArrayList<RemoteConfigurationRegistryConfig> result = new ArrayList<RemoteConfigurationRegistryConfig>();
        boolean useReferencedFile = false;
        String remoteConfigRegistryConfigFilename = System.getProperty(XML_CONFIG_REFERENCE_SYSTEM_PROPERTY_NAME);
        if (remoteConfigRegistryConfigFilename != null && (remoteConfigRegistryConfigFile = new File(remoteConfigRegistryConfigFilename)).exists()) {
            useReferencedFile = true;
            result.addAll(RemoteConfigurationRegistriesParser.getConfig(remoteConfigRegistryConfigFilename));
        }
        if (!useReferencedFile) {
            DefaultRemoteConfigurationRegistries remoteConfigRegistries = new DefaultRemoteConfigurationRegistries(gatewayConfig);
            result.addAll(((RemoteConfigurationRegistries)remoteConfigRegistries).getRegistryConfigurations());
        }
        return result;
    }
}

