/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.pac4j.config;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.pac4j.config.ClientConfigurationDecorator;
import org.pac4j.core.client.Client;
import org.pac4j.saml.client.SAML2Client;

public class SAML2ClientConfigurationDecorator
implements ClientConfigurationDecorator {
    private static final String SAML2_CLIENT_CLASS_NAME = SAML2Client.class.getSimpleName();
    private static final String CONFIG_NAME_USE_NAME_QUALIFIER = "useNameQualifier";
    private static final String CONFIG_NAME_USE_FORCE_AUTH = "forceAuth";
    private static final String CONFIG_NAME_USE_PASSIVE = "passive";
    private static final String CONFIG_NAME_NAMEID_POLICY_FORMAT = "nameIdPolicyFormat";

    @Override
    public void decorateClients(List<Client> clients, Map<String, String> properties) {
        for (Client client : clients) {
            if (!SAML2_CLIENT_CLASS_NAME.equalsIgnoreCase(client.getName())) continue;
            SAML2Client saml2Client = (SAML2Client)client;
            this.setUseNameQualifierFlag(properties, saml2Client);
            this.setForceAuthFlag(properties, saml2Client);
            this.setPassiveFlag(properties, saml2Client);
            this.setNameIdPolicyFormat(properties, saml2Client);
        }
    }

    private void setUseNameQualifierFlag(Map<String, String> properties, SAML2Client saml2Client) {
        String useNameQualifier = properties.get(CONFIG_NAME_USE_NAME_QUALIFIER);
        if (StringUtils.isNotBlank((CharSequence)useNameQualifier)) {
            saml2Client.getConfiguration().setUseNameQualifier(Boolean.valueOf(useNameQualifier).booleanValue());
        }
    }

    private void setForceAuthFlag(Map<String, String> properties, SAML2Client saml2Client) {
        String forceAuth = properties.get(CONFIG_NAME_USE_FORCE_AUTH);
        if (StringUtils.isNotBlank((CharSequence)forceAuth)) {
            saml2Client.getConfiguration().setForceAuth(Boolean.valueOf(forceAuth).booleanValue());
        }
    }

    private void setPassiveFlag(Map<String, String> properties, SAML2Client saml2Client) {
        String passive = properties.get(CONFIG_NAME_USE_PASSIVE);
        if (StringUtils.isNotBlank((CharSequence)passive)) {
            saml2Client.getConfiguration().setPassive(Boolean.valueOf(passive).booleanValue());
        }
    }

    private void setNameIdPolicyFormat(Map<String, String> properties, SAML2Client saml2Client) {
        String nameIdPolicyFormat = properties.get(CONFIG_NAME_NAMEID_POLICY_FORMAT);
        if (StringUtils.isNotBlank((CharSequence)nameIdPolicyFormat)) {
            saml2Client.getConfiguration().setNameIdPolicyFormat(nameIdPolicyFormat);
        }
    }
}

