/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.pagedSearch;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;

public class PagedResultsFactory
extends AbstractControlFactory<PagedResults> {
    public PagedResultsFactory(LdapApiService codec) {
        super(codec, "1.2.840.113556.1.4.319");
    }

    public PagedResults newControl() {
        return new PagedResultsImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])((PagedResults)control).getCookie());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)((PagedResults)control).getSize());
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new PagedResultsContainer(control), control, controlBytes);
    }
}

