/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dto;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class HomePageProfile {
    static final String GPI_PREFIX = "gpi_";
    static final String GPI_VERSION = "gpi_version";
    static final String GPI_CERT = "gpi_cert";
    static final String GPI_ADMIN_UI = "gpi_admin_ui";
    static final String GPI_ADMIN_API = "gpi_admin_api";
    static final String GPI_METADATA_API = "gpi_md_api";
    static final String GPI_TOKENS = "gpi_tokens";
    static final String TOPOLOGIES = "topologies";
    static final String TOPOLOGY_PREFIX = "top_";
    static final String ALL_TOPOLOGIES = "top_all";
    private final Map<String, String> profileElements = new HashMap<String, String>();

    public HomePageProfile(Collection<String> profileConfiguration) {
        this.addElement(GPI_VERSION, profileConfiguration);
        this.addElement(GPI_CERT, profileConfiguration);
        this.addElement(GPI_ADMIN_UI, profileConfiguration);
        this.addElement(GPI_ADMIN_API, profileConfiguration);
        this.addElement(GPI_METADATA_API, profileConfiguration);
        this.addElement(GPI_TOKENS, profileConfiguration);
        this.addTopologies(profileConfiguration);
    }

    private void addTopologies(Collection<String> profileConfiguration) {
        HashSet topologies = new HashSet();
        profileConfiguration.forEach(config -> {
            if (config.startsWith(TOPOLOGY_PREFIX)) {
                topologies.add(config.substring(TOPOLOGY_PREFIX.length()));
            }
        });
        this.profileElements.put(TOPOLOGIES, String.join((CharSequence)",", topologies));
    }

    private void addElement(String element, Collection<String> profileConfiguration) {
        if (profileConfiguration.contains(element)) {
            this.profileElements.put(element, Boolean.TRUE.toString());
        } else {
            this.profileElements.put(element, Boolean.FALSE.toString());
        }
    }

    public Map<String, String> getProfileElements() {
        return this.profileElements;
    }

    public static Collection<String> getFullProfileElements() {
        return Arrays.asList(GPI_VERSION, GPI_CERT, GPI_ADMIN_UI, GPI_ADMIN_API, GPI_METADATA_API, GPI_TOKENS);
    }

    public static Collection<String> getThinProfileElemens() {
        return Arrays.asList(GPI_VERSION, GPI_CERT);
    }

    public static Collection<String> getTokenProfileElements() {
        return Arrays.asList(GPI_VERSION, GPI_CERT, GPI_TOKENS);
    }
}

