/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class WhitelistUtils {
    static final String DEFAULT_CONFIG_VALUE = "DEFAULT";
    static final String DEFAULT_DISPATCH_WHITELIST_TEMPLATE = "^\\/.*$;^https?:\\/\\/%s:[0-9]+\\/?.*$";
    static final String HTTPS_ONLY_CONFIG_VALUE = "HTTPS_ONLY";
    static final String HTTPS_ONLY_DISPATCH_WHITELIST_TEMPLATE = "^\\/.*$;^https:\\/\\/%s:[0-9]+\\/?.*$";
    static final String LOCALHOST_REGEXP_SEGMENT = "(localhost|127\\.0\\.0\\.1|0:0:0:0:0:0:0:1|::1)";
    static final String LOCALHOST_REGEXP = "^(localhost|127\\.0\\.0\\.1|0:0:0:0:0:0:0:1|::1)$";
    private static final String IP_ADDRESS_REGEX = "^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$";
    private static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private static final List<String> DEFAULT_SERVICE_ROLES = Collections.singletonList("KNOXSSO");

    public static String getDispatchWhitelist(HttpServletRequest request) {
        String whitelist = null;
        GatewayConfig config = (GatewayConfig)request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (config != null) {
            ArrayList<String> whitelistedServiceRoles = new ArrayList<String>();
            whitelistedServiceRoles.addAll(DEFAULT_SERVICE_ROLES);
            whitelistedServiceRoles.addAll(config.getDispatchWhitelistServices());
            String serviceRole = (String)request.getAttribute("targetServiceRole");
            if (whitelistedServiceRoles.contains(serviceRole)) {
                whitelist = config.getDispatchWhitelist();
                if (whitelist == null || whitelist.equalsIgnoreCase(DEFAULT_CONFIG_VALUE)) {
                    whitelist = WhitelistUtils.deriveDefaultDispatchWhitelist(request, DEFAULT_DISPATCH_WHITELIST_TEMPLATE);
                    LOG.derivedDispatchWhitelist(whitelist);
                } else if (whitelist.equalsIgnoreCase(HTTPS_ONLY_CONFIG_VALUE)) {
                    whitelist = WhitelistUtils.deriveDefaultDispatchWhitelist(request, HTTPS_ONLY_DISPATCH_WHITELIST_TEMPLATE);
                    LOG.derivedDispatchWhitelist(whitelist);
                }
            }
        }
        return whitelist;
    }

    private static String deriveDefaultDispatchWhitelist(HttpServletRequest request, String whitelistTemplate) {
        String defaultWhitelist = null;
        String domain = WhitelistUtils.getDomain(request.getHeader("X-Forwarded-Host"));
        String requestedHost = null;
        if (domain == null) {
            requestedHost = request.getServerName();
            domain = WhitelistUtils.getDomain(requestedHost);
        }
        if (domain != null) {
            defaultWhitelist = WhitelistUtils.defineWhitelistForDomain(domain, whitelistTemplate);
        } else if (!requestedHost.matches(LOCALHOST_REGEXP)) {
            LOG.unableToDetermineKnoxDomainForDefaultWhitelist(requestedHost);
            defaultWhitelist = String.format(Locale.ROOT, whitelistTemplate, requestedHost);
        }
        if (defaultWhitelist == null) {
            LOG.unableToDetermineKnoxDomainForDefaultWhitelist("localhost");
            defaultWhitelist = String.format(Locale.ROOT, whitelistTemplate, LOCALHOST_REGEXP_SEGMENT);
        }
        return defaultWhitelist;
    }

    private static String getDomain(String hostname) {
        int domainIndex;
        String domain = null;
        if (hostname != null && !hostname.isEmpty() && !(hostname = WhitelistUtils.stripPort(hostname)).matches(IP_ADDRESS_REGEX) && (domainIndex = hostname.indexOf(46)) > 0) {
            domain = hostname.substring(hostname.indexOf(46));
        }
        return domain;
    }

    private static String defineWhitelistForDomain(String domain, String whitelistTemplate) {
        String whitelist = null;
        if (domain != null && !domain.isEmpty()) {
            String domainPattern = ".+" + domain.replaceAll("\\.", "\\\\.");
            whitelist = String.format(Locale.ROOT, whitelistTemplate, "(" + domainPattern + ")");
        }
        return whitelist;
    }

    private static String stripPort(String hostName) {
        String result = hostName;
        int portIndex = hostName.indexOf(58);
        if (portIndex > 0) {
            result = hostName.substring(0, portIndex);
        }
        return result;
    }
}

