/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import org.eclipse.persistence.internal.codegen.CodeGenerator;

public class AccessLevel {
    protected int level;
    public static final int PUBLIC = 1;
    public static final int PROTECTED = 2;
    public static final int PACKAGE = 3;
    public static final int PRIVATE = 4;
    protected boolean isAbstract;
    protected boolean isFinal;
    protected boolean isNative;
    protected boolean isStatic;
    protected boolean isSynchronized;
    protected boolean isTransient;
    protected boolean isVolatile;

    public AccessLevel() {
        this.level = 1;
        this.isStatic = false;
        this.isFinal = false;
        this.isTransient = false;
    }

    public AccessLevel(int level) {
        this.level = level;
        this.isStatic = false;
        this.isFinal = false;
        this.isTransient = false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessLevel)) {
            return false;
        }
        AccessLevel accessLevel = (AccessLevel)object;
        return this.level == accessLevel.level && this.isStatic == accessLevel.isStatic && this.isFinal == accessLevel.isFinal && this.isTransient == accessLevel.isTransient;
    }

    public int hashCode() {
        int result = this.level;
        result = 31 * result + (this.isAbstract ? 1 : 0);
        result = 31 * result + (this.isFinal ? 1 : 0);
        result = 31 * result + (this.isNative ? 1 : 0);
        result = 31 * result + (this.isStatic ? 1 : 0);
        result = 31 * result + (this.isSynchronized ? 1 : 0);
        result = 31 * result + (this.isTransient ? 1 : 0);
        result = 31 * result + (this.isVolatile ? 1 : 0);
        return result;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setIsNative(boolean isNative) {
        this.isNative = isNative;
    }

    public void setIsStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setIsSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public void setIsTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setIsVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void write(CodeGenerator generator) {
        boolean needsSpace = true;
        if (this.getLevel() == 1) {
            generator.write("public");
        } else if (this.getLevel() == 2) {
            generator.write("protected");
        } else if (this.getLevel() == 3) {
            needsSpace = false;
        } else if (this.getLevel() == 4) {
            generator.write("private");
        }
        if (this.isAbstract()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("abstract");
            needsSpace = true;
        }
        if (this.isStatic()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("static");
            needsSpace = true;
        }
        if (this.isFinal()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("final");
            needsSpace = true;
        }
        if (this.isTransient()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("transient");
            needsSpace = true;
        }
        if (this.isVolatile()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("volatile");
            needsSpace = true;
        }
        if (this.isNative()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("native");
            needsSpace = true;
        }
        if (this.isSynchronized()) {
            if (needsSpace) {
                generator.write(" ");
            }
            generator.write("synchronized");
            needsSpace = true;
        }
    }
}

