/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiEvent;
import com.cloudera.api.swagger.model.ApiEventQueryResult;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class EventsResourceApi {
    private ApiClient apiClient;

    public EventsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call readEventCall(String eventId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/events/{eventId}".replaceAll("\\{eventId\\}", this.apiClient.escapeString(eventId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readEventValidateBeforeCall(String eventId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (eventId == null) {
            throw new ApiException("Missing the required parameter 'eventId' when calling readEvent(Async)");
        }
        Call call = this.readEventCall(eventId, progressListener, progressRequestListener);
        return call;
    }

    public ApiEvent readEvent(String eventId) throws ApiException {
        ApiResponse<ApiEvent> resp = this.readEventWithHttpInfo(eventId);
        return resp.getData();
    }

    public ApiResponse<ApiEvent> readEventWithHttpInfo(String eventId) throws ApiException {
        Call call = this.readEventValidateBeforeCall(eventId, null, null);
        Type localVarReturnType = new TypeToken<ApiEvent>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readEventAsync(String eventId, final ApiCallback<ApiEvent> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readEventValidateBeforeCall(eventId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiEvent>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readEventsCall(BigDecimal maxResults, String query, BigDecimal resultOffset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxResults", maxResults));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        }
        if (resultOffset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "resultOffset", resultOffset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readEventsValidateBeforeCall(BigDecimal maxResults, String query, BigDecimal resultOffset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.readEventsCall(maxResults, query, resultOffset, progressListener, progressRequestListener);
        return call;
    }

    public ApiEventQueryResult readEvents(BigDecimal maxResults, String query, BigDecimal resultOffset) throws ApiException {
        ApiResponse<ApiEventQueryResult> resp = this.readEventsWithHttpInfo(maxResults, query, resultOffset);
        return resp.getData();
    }

    public ApiResponse<ApiEventQueryResult> readEventsWithHttpInfo(BigDecimal maxResults, String query, BigDecimal resultOffset) throws ApiException {
        Call call = this.readEventsValidateBeforeCall(maxResults, query, resultOffset, null, null);
        Type localVarReturnType = new TypeToken<ApiEventQueryResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readEventsAsync(BigDecimal maxResults, String query, BigDecimal resultOffset, final ApiCallback<ApiEventQueryResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readEventsValidateBeforeCall(maxResults, query, resultOffset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiEventQueryResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

