/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiImpalaCancelResponse;
import com.cloudera.api.swagger.model.ApiImpalaQueryAttributeList;
import com.cloudera.api.swagger.model.ApiImpalaQueryDetailsResponse;
import com.cloudera.api.swagger.model.ApiImpalaQueryResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class ImpalaQueriesResourceApi {
    private ApiClient apiClient;

    public ImpalaQueriesResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImpalaQueriesResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call cancelImpalaQueryCall(String clusterName, String queryId, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/impalaQueries/{queryId}/cancel".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelImpalaQueryValidateBeforeCall(String clusterName, String queryId, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling cancelImpalaQuery(Async)");
        }
        if (queryId == null) {
            throw new ApiException("Missing the required parameter 'queryId' when calling cancelImpalaQuery(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling cancelImpalaQuery(Async)");
        }
        Call call = this.cancelImpalaQueryCall(clusterName, queryId, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiImpalaCancelResponse cancelImpalaQuery(String clusterName, String queryId, String serviceName) throws ApiException {
        ApiResponse<ApiImpalaCancelResponse> resp = this.cancelImpalaQueryWithHttpInfo(clusterName, queryId, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiImpalaCancelResponse> cancelImpalaQueryWithHttpInfo(String clusterName, String queryId, String serviceName) throws ApiException {
        Call call = this.cancelImpalaQueryValidateBeforeCall(clusterName, queryId, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiImpalaCancelResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelImpalaQueryAsync(String clusterName, String queryId, String serviceName, final ApiCallback<ApiImpalaCancelResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelImpalaQueryValidateBeforeCall(clusterName, queryId, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiImpalaCancelResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getImpalaQueriesCall(String clusterName, String serviceName, String filter, String from, BigDecimal limit, BigDecimal offset, String to, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/impalaQueries".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getImpalaQueriesValidateBeforeCall(String clusterName, String serviceName, String filter, String from, BigDecimal limit, BigDecimal offset, String to, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getImpalaQueries(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getImpalaQueries(Async)");
        }
        Call call = this.getImpalaQueriesCall(clusterName, serviceName, filter, from, limit, offset, to, progressListener, progressRequestListener);
        return call;
    }

    public ApiImpalaQueryResponse getImpalaQueries(String clusterName, String serviceName, String filter, String from, BigDecimal limit, BigDecimal offset, String to) throws ApiException {
        ApiResponse<ApiImpalaQueryResponse> resp = this.getImpalaQueriesWithHttpInfo(clusterName, serviceName, filter, from, limit, offset, to);
        return resp.getData();
    }

    public ApiResponse<ApiImpalaQueryResponse> getImpalaQueriesWithHttpInfo(String clusterName, String serviceName, String filter, String from, BigDecimal limit, BigDecimal offset, String to) throws ApiException {
        Call call = this.getImpalaQueriesValidateBeforeCall(clusterName, serviceName, filter, from, limit, offset, to, null, null);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getImpalaQueriesAsync(String clusterName, String serviceName, String filter, String from, BigDecimal limit, BigDecimal offset, String to, final ApiCallback<ApiImpalaQueryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getImpalaQueriesValidateBeforeCall(clusterName, serviceName, filter, from, limit, offset, to, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getImpalaQueryAttributesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/impalaQueries/attributes".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getImpalaQueryAttributesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getImpalaQueryAttributes(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getImpalaQueryAttributes(Async)");
        }
        Call call = this.getImpalaQueryAttributesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiImpalaQueryAttributeList getImpalaQueryAttributes(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiImpalaQueryAttributeList> resp = this.getImpalaQueryAttributesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiImpalaQueryAttributeList> getImpalaQueryAttributesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.getImpalaQueryAttributesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryAttributeList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getImpalaQueryAttributesAsync(String clusterName, String serviceName, final ApiCallback<ApiImpalaQueryAttributeList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getImpalaQueryAttributesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryAttributeList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getQueryDetailsCall(String clusterName, String queryId, String serviceName, String format, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/impalaQueries/{queryId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{queryId\\}", this.apiClient.escapeString(queryId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (format != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "format", format));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getQueryDetailsValidateBeforeCall(String clusterName, String queryId, String serviceName, String format, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getQueryDetails(Async)");
        }
        if (queryId == null) {
            throw new ApiException("Missing the required parameter 'queryId' when calling getQueryDetails(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getQueryDetails(Async)");
        }
        Call call = this.getQueryDetailsCall(clusterName, queryId, serviceName, format, progressListener, progressRequestListener);
        return call;
    }

    public ApiImpalaQueryDetailsResponse getQueryDetails(String clusterName, String queryId, String serviceName, String format) throws ApiException {
        ApiResponse<ApiImpalaQueryDetailsResponse> resp = this.getQueryDetailsWithHttpInfo(clusterName, queryId, serviceName, format);
        return resp.getData();
    }

    public ApiResponse<ApiImpalaQueryDetailsResponse> getQueryDetailsWithHttpInfo(String clusterName, String queryId, String serviceName, String format) throws ApiException {
        Call call = this.getQueryDetailsValidateBeforeCall(clusterName, queryId, serviceName, format, null, null);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryDetailsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getQueryDetailsAsync(String clusterName, String queryId, String serviceName, String format, final ApiCallback<ApiImpalaQueryDetailsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getQueryDetailsValidateBeforeCall(clusterName, queryId, serviceName, format, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiImpalaQueryDetailsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

